/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationRecord;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseAnnotationRecordDefault
implements HpoDiseaseAnnotationRecord {
    private final Ratio ratio;
    private final TemporalInterval temporalInterval;
    private final Collection<AnnotationReference> references;
    private final Sex sex;
    private final Collection<TermId> modifiers;

    HpoDiseaseAnnotationRecordDefault(Ratio ratio, TemporalInterval temporalInterval, Collection<AnnotationReference> references, Sex sex, Collection<TermId> modifiers) {
        this.ratio = Objects.requireNonNull(ratio);
        this.temporalInterval = temporalInterval;
        this.references = Objects.requireNonNull(references);
        this.sex = sex;
        this.modifiers = Objects.requireNonNull(modifiers);
    }

    @Override
    public Ratio ratio() {
        return this.ratio;
    }

    @Override
    public Optional<TemporalInterval> temporalInterval() {
        return Optional.ofNullable(this.temporalInterval);
    }

    @Override
    public Collection<AnnotationReference> references() {
        return this.references;
    }

    @Override
    public Collection<TermId> modifiers() {
        return this.modifiers;
    }

    @Override
    public Optional<Sex> sex() {
        return Optional.ofNullable(this.sex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ratio, this.temporalInterval, this.references, this.sex, this.modifiers});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoDiseaseAnnotationRecordDefault that = (HpoDiseaseAnnotationRecordDefault)o;
        return Objects.equals(this.ratio, that.ratio) && Objects.equals(this.temporalInterval, that.temporalInterval) && Objects.equals(this.references, that.references) && this.sex == that.sex && Objects.equals(this.modifiers, that.modifiers);
    }

    public String toString() {
        return "HpoDiseaseAnnotationRecordDefault{ratio=" + String.valueOf(this.ratio) + ", temporalInterval=" + String.valueOf(this.temporalInterval) + ", reference=" + String.valueOf(this.references) + ", sex=" + String.valueOf((Object)this.sex) + ", modifiers=" + String.valueOf(this.modifiers) + "}";
    }
}

