/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.assoc.DiseaseToGeneAssociationLoader;
import org.monarchinitiative.phenol.annotations.assoc.GeneIdentifierLoader;
import org.monarchinitiative.phenol.annotations.assoc.GeneIdentifierLoaders;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoGeneType;
import org.monarchinitiative.phenol.annotations.assoc.MissingPhenolResourceException;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItem;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItemContainer;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationData;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotations;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpoAssociationDataBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoAssociationDataBuilder.class);
    private final Ontology hpo;
    private Path homoSapiensGeneInfoPath;
    private Set<GeneInfoGeneType> geneInfoTypes;
    private Path hgncCompleteSetArchivePath;
    private GeneIdentifiers geneIdentifiers;
    private Path mim2geneMedgenPath;
    private Path orphaToGenePath;
    private DiseaseToGeneAssociations diseaseToGeneAssociations;
    private AnnotatedItemContainer<? extends AnnotatedItem> diseases;
    private HpoGeneAnnotations hpoGeneAnnotations;

    HpoAssociationDataBuilder(Ontology hpo) {
        this.hpo = Objects.requireNonNull(hpo);
    }

    public HpoAssociationDataBuilder homoSapiensGeneInfo(Path homoSapiensGeneInfo, Set<GeneInfoGeneType> geneInfoTypes) {
        this.homoSapiensGeneInfoPath = homoSapiensGeneInfo;
        this.geneInfoTypes = geneInfoTypes;
        this.hgncCompleteSetArchivePath = null;
        return this;
    }

    public HpoAssociationDataBuilder hgncCompleteSetArchive(Path hgncCompleteSetArchivePath) {
        this.hgncCompleteSetArchivePath = hgncCompleteSetArchivePath;
        this.homoSapiensGeneInfoPath = null;
        this.geneInfoTypes = null;
        return this;
    }

    public HpoAssociationDataBuilder geneIdentifiers(GeneIdentifiers geneIdentifiers) {
        this.geneIdentifiers = geneIdentifiers;
        return this;
    }

    public HpoAssociationDataBuilder mim2GeneMedgen(Path mim2geneMedgenPath) {
        this.mim2geneMedgenPath = mim2geneMedgenPath;
        return this;
    }

    public HpoAssociationDataBuilder orphaToGenePath(Path orphaToGenePath) {
        this.orphaToGenePath = orphaToGenePath;
        return this;
    }

    public HpoAssociationDataBuilder diseaseToGeneAssociations(DiseaseToGeneAssociations diseaseToGeneAssociations) {
        this.diseaseToGeneAssociations = diseaseToGeneAssociations;
        return this;
    }

    public HpoAssociationDataBuilder hpoDiseases(AnnotatedItemContainer<? extends AnnotatedItem> diseases) {
        this.diseases = diseases;
        return this;
    }

    public HpoAssociationDataBuilder hpoGeneAnnotations(HpoGeneAnnotations hpoGeneAnnotations) {
        this.hpoGeneAnnotations = hpoGeneAnnotations;
        return this;
    }

    public HpoAssociationData build() throws MissingPhenolResourceException {
        if (this.geneIdentifiers == null) {
            Path giPath;
            GeneIdentifierLoader loader;
            LOGGER.debug("Gene identifiers are unset.");
            if (this.homoSapiensGeneInfoPath != null && this.geneInfoTypes != null) {
                LOGGER.debug("Loading gene identifiers from Homo sapiens gene info file at {}", (Object)this.homoSapiensGeneInfoPath.toAbsolutePath());
                loader = GeneIdentifierLoaders.forHumanGeneInfo(this.geneInfoTypes);
                giPath = this.homoSapiensGeneInfoPath;
            } else if (this.hgncCompleteSetArchivePath != null) {
                LOGGER.debug("Loading gene identifiers from HGNC complete set archive file at {}", (Object)this.hgncCompleteSetArchivePath.toAbsolutePath());
                loader = GeneIdentifierLoaders.forHgncCompleteSetArchive();
                giPath = this.hgncCompleteSetArchivePath;
            } else {
                throw new MissingPhenolResourceException("Gene identifiers are unset and neither Homo sapiens gene info path nor HGNC complete set archive path is set!");
            }
            try {
                this.geneIdentifiers = loader.load(giPath);
            }
            catch (IOException e) {
                throw new MissingPhenolResourceException(e);
            }
        }
        if (this.diseaseToGeneAssociations == null) {
            LOGGER.debug("Disease to gene associations are unset.");
            if (this.mim2geneMedgenPath != null) {
                try {
                    LOGGER.debug("Loading disease to gene associations from {}", (Object)this.mim2geneMedgenPath);
                    this.diseaseToGeneAssociations = DiseaseToGeneAssociationLoader.loadDiseaseToGeneAssociations(this.mim2geneMedgenPath, this.orphaToGenePath, this.geneIdentifiers);
                }
                catch (IOException e) {
                    throw new MissingPhenolResourceException(e);
                }
            } else {
                throw new MissingPhenolResourceException("Disease to gene associations and MIM 2 gene medgen paths are unset!");
            }
        }
        if (this.hpoGeneAnnotations == null) {
            LOGGER.debug("HPO gene annotations are unset.");
            if (this.diseases != null) {
                LOGGER.debug("Loading HPO gene annotations.");
                this.hpoGeneAnnotations = HpoAssociationDataBuilder.loadHpoGeneAnnotations(this.diseases, this.hpo.getTermMap(), this.diseaseToGeneAssociations.diseaseIdToGeneAssociations());
            } else {
                throw new MissingPhenolResourceException("HPO diseases are unset!");
            }
        }
        return HpoAssociationData.of(this.geneIdentifiers, this.hpoGeneAnnotations, this.diseaseToGeneAssociations);
    }

    private static HpoGeneAnnotations loadHpoGeneAnnotations(AnnotatedItemContainer<? extends AnnotatedItem> diseases, Map<TermId, Term> termIdToTerm, Map<TermId, Collection<GeneToAssociation>> diseaseToGeneMap) {
        HashMap<TermId, Collection> phenotypeToDisease = new HashMap<TermId, Collection>();
        for (AnnotatedItem annotatedItem : diseases) {
            for (Identified identified : annotatedItem.annotations()) {
                TermId hpoId = identified.id();
                phenotypeToDisease.computeIfAbsent(hpoId, k -> new HashSet()).add(annotatedItem.id());
            }
        }
        ArrayList<HpoGeneAnnotation> geneAnnotationListBuilder = new ArrayList<HpoGeneAnnotation>();
        HashSet hashSet = new HashSet();
        for (TermId termId : phenotypeToDisease.keySet()) {
            Term phenotypeTerm = termIdToTerm.get(termId);
            if (phenotypeTerm != null) {
                ((Collection)phenotypeToDisease.get(termId)).stream().flatMap(disease -> ((Collection)diseaseToGeneMap.getOrDefault(disease, List.of())).stream()).map(GeneToAssociation::geneIdentifier).forEach(geneId -> {
                    try {
                        if (!hashSet.contains(geneId.id())) {
                            int entrezId = Integer.parseInt(geneId.id().getId());
                            String entrezGeneSymbol = geneId.symbol();
                            HpoGeneAnnotation geneAnnotation = new HpoGeneAnnotation(entrezId, entrezGeneSymbol, termId, phenotypeTerm.getName());
                            geneAnnotationListBuilder.add(geneAnnotation);
                            hashSet.add(geneId.id());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("An exception found during creating HPO-gene annotations: " + e.getMessage() + " for gene: " + geneId.toString());
                    }
                });
            }
            hashSet.clear();
        }
        return HpoGeneAnnotations.of(geneAnnotationListBuilder);
    }
}

