/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalIntervals;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalOverlapType;

public interface TemporalInterval {
    public static TemporalInterval gestationalPeriod() {
        return TemporalIntervals.GESTATIONAL_PERIOD;
    }

    public static TemporalInterval postnatalPeriod() {
        return TemporalIntervals.POSTNATAL_PERIOD;
    }

    public static TemporalInterval of(PointInTime start, PointInTime end) {
        int result = PointInTime.compare(Objects.requireNonNull(start), Objects.requireNonNull(end));
        if (result > 0) {
            throw new IllegalArgumentException(String.format("Start (%d days) must not be after end (%d days)", start.days(), end.days()));
        }
        return TemporalIntervals.of(start, end);
    }

    public static TemporalInterval open() {
        return TemporalIntervals.OPEN;
    }

    public static TemporalInterval openStart(PointInTime end) {
        return Objects.requireNonNull(end).isOpen() ? TemporalIntervals.OPEN : new TemporalIntervals.TemporalIntervalWithOpenStart(end);
    }

    public static TemporalInterval openEnd(PointInTime start) {
        return Objects.requireNonNull(start).isOpen() ? TemporalIntervals.OPEN : new TemporalIntervals.TemporalIntervalWithOpenEnd(start);
    }

    public PointInTime start();

    public PointInTime end();

    default public boolean isStartOpen() {
        return this.start().isOpen();
    }

    default public boolean isStartClosed() {
        return !this.isStartOpen();
    }

    default public boolean isEndOpen() {
        return this.end().isOpen();
    }

    default public boolean isEndClosed() {
        return !this.isEndOpen();
    }

    default public boolean isFullyOpen() {
        return this.isStartOpen() && this.isEndOpen();
    }

    default public boolean isFullyClosed() {
        return this.isStartClosed() && this.isEndClosed();
    }

    default public int length() {
        return this.isFullyClosed() && this.start().isGestational() == this.end().isGestational() ? this.end().days() - this.start().days() : Integer.MAX_VALUE;
    }

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    default public TemporalInterval intersection(TemporalInterval other) {
        PointInTime end;
        PointInTime start = PointInTime.max(this.start(), other.start());
        int compare = PointInTime.compare(start, end = PointInTime.min(this.end(), other.end()));
        if (compare > 0) {
            return TemporalIntervals.BIRTH;
        }
        return TemporalInterval.of(start, end);
    }

    default public boolean overlapsWith(TemporalInterval other) {
        switch (this.temporalOverlapType(other)) {
            case BEFORE: 
            case AFTER: {
                return false;
            }
            case BEFORE_AND_DURING: 
            case CONTAINS: 
            case CONTAINED_IN: 
            case DURING_AND_AFTER: {
                return true;
            }
        }
        throw new RuntimeException(String.format("Unknown item %s", new Object[]{this.temporalOverlapType(other)}));
    }

    default public TemporalOverlapType temporalOverlapType(TemporalInterval other) {
        return TemporalInterval.temporalOverlapType(this, other);
    }

    default public boolean contains(PointInTime age) {
        int start = PointInTime.compare(this.start(), age);
        int end = PointInTime.compare(this.end(), age);
        return start <= 0 && 0 < end;
    }

    public static int compare(TemporalInterval x, TemporalInterval y) {
        int result = PointInTime.compare(x.start(), y.start());
        if (result != 0) {
            return result;
        }
        return PointInTime.compare(x.end(), y.end());
    }

    private static TemporalOverlapType temporalOverlapType(TemporalInterval x, TemporalInterval y) {
        if (x.end().isAtOrBefore(y.start())) {
            return x.isEmpty() && x.end().isAt(y.start()) ? TemporalOverlapType.CONTAINED_IN : TemporalOverlapType.BEFORE;
        }
        if (x.start().isAtOrAfter(y.end())) {
            return x.isEmpty() && x.start().isAt(y.end()) ? TemporalOverlapType.CONTAINED_IN : TemporalOverlapType.AFTER;
        }
        int startCompare = PointInTime.compare(x.start(), y.start());
        if (startCompare < 0) {
            if (x.end().isBefore(y.end())) {
                return TemporalOverlapType.BEFORE_AND_DURING;
            }
            return TemporalOverlapType.CONTAINS;
        }
        if (x.end().isAtOrBefore(y.end())) {
            return TemporalOverlapType.CONTAINED_IN;
        }
        return startCompare == 0 ? TemporalOverlapType.CONTAINS : TemporalOverlapType.DURING_AND_AFTER;
    }
}

