/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.obo.mpo;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpGeneticMarker;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpGeneParser {
    private MpGeneParser() {
    }

    public static Map<TermId, MpGeneticMarker> loadMarkerMap(String markerPath) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try (BufferedReader br = new BufferedReader(new FileReader(markerPath));){
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\t");
                if (fields.length < 11) {
                    throw new PhenolRuntimeException("Malformed line of MRK_List2.rpt file with less than 11 fields:" + line);
                }
                TermId mgiId = TermId.of((String)fields[0]);
                builder.put((Object)mgiId, (Object)MpGeneticMarker.createMpGeneticMarker(mgiId, fields[6], fields[9], fields[10]));
            }
        }
        catch (IOException e) {
            System.err.println("Could not read MGI Marker file" + markerPath);
        }
        return builder.build();
    }
}

