/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.obo.hpo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.annotations.obo.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermIds;

public class HpoDiseaseAnnotationParser {
    private final String annotationFilePath;
    private final Ontology ontology;
    private final Map<TermId, HpoDisease> diseaseMap;
    private ImmutableMultimap<TermId, TermId> phenotypeToDiseaseMap;
    private List<String> errors;
    private final Set<String> DEFAULT_DATABASE_PREFIXES = ImmutableSet.of((Object)"OMIM", (Object)"ORPHA", (Object)"DECIPHER");
    private final Set<String> databasePrefixes;

    public static Map<TermId, HpoDisease> loadDiseaseMap(String annotationFile, Ontology ontology) {
        HpoDiseaseAnnotationParser parser = new HpoDiseaseAnnotationParser(annotationFile, ontology);
        try {
            return parser.parse();
        }
        catch (PhenolException e) {
            System.err.println("Could not load HPO annotations at " + annotationFile + ": " + e.getMessage());
            throw new PhenolRuntimeException("Could not load HPO annotations at " + annotationFile);
        }
    }

    public static Map<TermId, HpoDisease> loadDiseaseMap(String annotationFile, Ontology ontology, List<String> databases) {
        HpoDiseaseAnnotationParser parser = new HpoDiseaseAnnotationParser(annotationFile, ontology, databases);
        try {
            return parser.parse();
        }
        catch (PhenolException e) {
            System.err.println("Could not load HPO annotations at " + annotationFile + ": " + e.getMessage());
            throw new PhenolRuntimeException("Could not load HPO annotations at " + annotationFile);
        }
    }

    private HpoDiseaseAnnotationParser(String annotationFile, Ontology ontology) {
        this.annotationFilePath = annotationFile;
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        this.databasePrefixes = this.DEFAULT_DATABASE_PREFIXES;
    }

    private HpoDiseaseAnnotationParser(String annotationFile, Ontology ontology, List<String> databases) {
        this.annotationFilePath = annotationFile;
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String database : databases) {
            builder.add((Object)database);
        }
        this.databasePrefixes = builder.build();
    }

    private HpoDiseaseAnnotationParser(File annotationFile, Ontology ontology) {
        this.annotationFilePath = annotationFile.getAbsolutePath();
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        this.databasePrefixes = this.DEFAULT_DATABASE_PREFIXES;
    }

    public boolean validParse() {
        return this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private ImmutableMultimap<TermId, TermId> getTermToDiseaseMap() {
        return this.phenotypeToDiseaseMap;
    }

    public static Multimap<TermId, TermId> loadTermToDiseaseMap(String annotationFile, Ontology ontology) {
        HpoDiseaseAnnotationParser parser = new HpoDiseaseAnnotationParser(annotationFile, ontology);
        try {
            parser.parse();
            return parser.getTermToDiseaseMap();
        }
        catch (PhenolException e) {
            System.err.println("Could not load HPO annotations at " + annotationFile + ": " + e.getMessage());
            throw new PhenolRuntimeException("Could not load HPO annotations at " + annotationFile);
        }
    }

    public Map<TermId, HpoDisease> parse() throws PhenolException {
        HashMap disease2AnnotLineMap = new HashMap();
        ArrayListMultimap termToDisease = ArrayListMultimap.create();
        ImmutableList.Builder errorbuilder = new ImmutableList.Builder();
        try (BufferedReader br = new BufferedReader(new FileReader(this.annotationFilePath));){
            String line = br.readLine();
            while (line.startsWith("#")) {
                line = br.readLine();
            }
            while ((line = br.readLine()) != null) {
                HpoAnnotationLine aline = HpoAnnotationLine.constructFromString(line);
                if (!aline.hasValidNumberOfFields()) {
                    errorbuilder.add((Object)String.format("Invalid number of fields: %s", line));
                    continue;
                }
                if (!termToDisease.containsEntry((Object)aline.getPhenotypeId(), (Object)aline.getDiseaseTermId())) {
                    termToDisease.put((Object)aline.getPhenotypeId(), (Object)aline.getDiseaseTermId());
                }
                TermId diseaseId = aline.getDiseaseTermId();
                disease2AnnotLineMap.putIfAbsent(diseaseId, new ArrayList());
                List annots = (List)disease2AnnotLineMap.get(diseaseId);
                annots.add(aline);
            }
            ImmutableMultimap.Builder builderTermToDisease = new ImmutableMultimap.Builder();
            builderTermToDisease.putAll((Multimap)termToDisease);
            this.phenotypeToDiseaseMap = builderTermToDisease.build();
        }
        catch (IOException e) {
            throw new PhenolException(String.format("Could not read annotation file: %s", e.getMessage()));
        }
        for (TermId diseaseId : disease2AnnotLineMap.keySet()) {
            String diseaseDatabasePrefix = diseaseId.getPrefix();
            if (!this.databasePrefixes.contains(diseaseDatabasePrefix)) continue;
            List annots = (List)disease2AnnotLineMap.get(diseaseId);
            ImmutableList.Builder phenoListBuilder = ImmutableList.builder();
            ImmutableList.Builder inheritanceListBuilder = ImmutableList.builder();
            ImmutableList.Builder negativeTermListBuilder = ImmutableList.builder();
            ImmutableList.Builder clinicalModifierListBuilder = ImmutableList.builder();
            ImmutableList.Builder clinicalCourseListBuilder = ImmutableList.builder();
            String diseaseName = null;
            for (HpoAnnotationLine line : annots) {
                try {
                    if (this.isInheritanceTerm(line.getPhenotypeId())) {
                        inheritanceListBuilder.add((Object)line.getPhenotypeId());
                    } else if (this.isClinicalModifierTerm(line.getPhenotypeId())) {
                        clinicalModifierListBuilder.add((Object)line.getPhenotypeId());
                    } else if (this.isClinicalCourse(line.getPhenotypeId())) {
                        clinicalCourseListBuilder.add((Object)line.getPhenotypeId());
                    } else if (line.isNOT()) {
                        negativeTermListBuilder.add((Object)line.getPhenotypeId());
                    } else {
                        HpoAnnotation tidm = HpoAnnotationLine.toHpoAnnotation(line, this.ontology);
                        phenoListBuilder.add((Object)tidm);
                    }
                    if (line.getDbObjectName() == null) continue;
                    diseaseName = line.getDbObjectName();
                }
                catch (Exception e) {
                    errorbuilder.add((Object)String.format("PHENOL ERROR] Line: %s--could not parse annotation: %s ", line.toString(), e.getMessage()));
                }
            }
            HpoDisease hpoDisease = new HpoDisease(diseaseName, diseaseId, (List<HpoAnnotation>)phenoListBuilder.build(), (List<TermId>)inheritanceListBuilder.build(), (List<TermId>)negativeTermListBuilder.build(), (List<TermId>)clinicalModifierListBuilder.build(), (List<TermId>)clinicalCourseListBuilder.build());
            this.diseaseMap.put(hpoDisease.getDiseaseDatabaseId(), hpoDisease);
        }
        this.errors = errorbuilder.build();
        return this.diseaseMap;
    }

    private boolean isInheritanceTerm(TermId tid) {
        return tid.equals((Object)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT);
    }

    private boolean isClinicalModifierTerm(TermId tid) {
        TermId CLINICAL_MODIFIER_ROOT = TermId.of((String)"HP:0012823");
        return tid.equals((Object)CLINICAL_MODIFIER_ROOT) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)CLINICAL_MODIFIER_ROOT);
    }

    private boolean isClinicalCourse(TermId tid) {
        TermId CLINICAL_COURSE = TermId.of((String)"HP:0031797");
        return tid.equals((Object)CLINICAL_COURSE) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)CLINICAL_COURSE);
    }

    public static Map<TermId, Collection<TermId>> diseaseIdToDirectHpoTermIds(Map<TermId, HpoDisease> diseaseMap) {
        HashMap<TermId, List<TermId>> tmpMap = new HashMap<TermId, List<TermId>>();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List<TermId> hpoTerms = disease.getPhenotypicAbnormalityTermIdList();
            tmpMap.put(diseaseId, hpoTerms);
        }
        return ImmutableMap.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> hpoTermIdToDiseaseIdsDirect(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List<TermId> hpoTermIds = disease.getPhenotypicAbnormalityTermIdList();
            for (TermId tid : hpoTermIds) {
                tmpMap.putIfAbsent(tid, new HashSet());
                ((Collection)tmpMap.get(tid)).add(diseaseId);
            }
        }
        return ImmutableMap.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> diseaseIdToPropagatedHpoTermIds(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            tmpMap.putIfAbsent(diseaseId, new HashSet());
            List<TermId> hpoTerms = disease.getPhenotypicAbnormalityTermIdList();
            Set inclAncestorTermIds = TermIds.augmentWithAncestors((Ontology)ontology, (Set)Sets.newHashSet(hpoTerms), (boolean)true);
            for (TermId tid : inclAncestorTermIds) {
                ((Collection)tmpMap.get(diseaseId)).add(tid);
            }
        }
        return ImmutableMap.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> hpoTermIdToDiseaseIdsPropagated(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List<TermId> hpoTermIds = disease.getPhenotypicAbnormalityTermIdList();
            Set inclAncestorTermIds = TermIds.augmentWithAncestors((Ontology)ontology, (Set)Sets.newHashSet(hpoTermIds), (boolean)true);
            for (TermId tid : inclAncestorTermIds) {
                tmpMap.putIfAbsent(tid, new HashSet());
                ((Collection)tmpMap.get(tid)).add(diseaseId);
            }
        }
        return ImmutableMap.copyOf(tmpMap);
    }
}

