/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.obo.go;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.monarchinitiative.phenol.annotations.formats.go.GoGaf21Annotation;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;

public final class GoGeneAnnotationParser {
    private GoGeneAnnotationParser() {
    }

    public static List<GoGaf21Annotation> loadAnnotations(String filename) {
        File f = new File(filename);
        return GoGeneAnnotationParser.loadAnnotations(f.toPath());
    }

    public static List<GoGaf21Annotation> loadAnnotations(File file) {
        return GoGeneAnnotationParser.loadAnnotations(file.toPath());
    }

    public static List<GoGaf21Annotation> loadAnnotations(Path path) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        try (BufferedReader br = Files.newBufferedReader(path);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("!")) continue;
                try {
                    GoGaf21Annotation annot = GoGaf21Annotation.parseAnnotation(line);
                    builder.add((Object)annot);
                }
                catch (PhenolException e) {
                    System.err.printf("[ERROR] Could not parse GoGaf line (%s): %s", line, e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Could not parse " + path.toString() + ": " + e.getMessage());
        }
        return builder.build();
    }

    public static List<TermAnnotation> loadTermAnnotations(String filename) {
        File f = new File(filename);
        return GoGeneAnnotationParser.loadTermAnnotations(f.toPath());
    }

    public static List<TermAnnotation> loadTermAnnotations(File file) {
        return GoGeneAnnotationParser.loadTermAnnotations(file.toPath());
    }

    public static List<TermAnnotation> loadTermAnnotations(Path path) {
        List<GoGaf21Annotation> annots = GoGeneAnnotationParser.loadAnnotations(path);
        return new ArrayList<TermAnnotation>(annots);
    }
}

