/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationFileIngestor;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModelException;
import org.monarchinitiative.phenol.annotations.hpo.OrphanetInheritanceXMLParser;
import org.monarchinitiative.phenol.annotations.hpo.OrphanetXML2HpoDiseaseModelParser;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhenotypeDotHpoaFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(PhenotypeDotHpoaFileWriter.class);
    private final List<HpoAnnotationModel> internalAnnotationModelList;
    private final List<HpoAnnotationModel> orphanetSmallFileList;
    private final Multimap<TermId, HpoAnnotationEntry> inheritanceMultiMap;
    private final boolean tolerant;
    private final boolean merge_frequency;
    private final String outputFileName;
    private final Ontology ontology;
    private int n_orphanet;
    private int n_decipher;
    private int n_omim;
    private int n_unknown;
    private Map<String, String> ontologyMetaInfo;
    private final File smallFileDirectory;
    private final File orphaPhenotypeXMLfile;
    private final File orphaInheritanceXMLfile;
    private final List<String> parseResultAndErrorSummaryLines;

    public static PhenotypeDotHpoaFileWriter factory(Ontology ont, String smallFileDirectoryPath, String orphaPhenotypeXMLpath, String orphaInheritanceXMLpath, String outpath, boolean toler, boolean merge_fr) {
        return new PhenotypeDotHpoaFileWriter(ont, smallFileDirectoryPath, orphaPhenotypeXMLpath, orphaInheritanceXMLpath, outpath, toler, merge_fr);
    }

    private PhenotypeDotHpoaFileWriter(Ontology ont, String smallFileDirectoryPath, String orphaPhenotypeXMLpath, String orphaInheritanceXMLpath, String outpath, boolean toler, boolean merge_fr) {
        Objects.requireNonNull(ont);
        this.ontology = ont;
        Objects.requireNonNull(outpath);
        this.outputFileName = outpath;
        this.parseResultAndErrorSummaryLines = new ArrayList<String>();
        this.smallFileDirectory = new File(smallFileDirectoryPath);
        if (!this.smallFileDirectory.exists()) {
            throw new PhenolRuntimeException("Could not find " + smallFileDirectoryPath + " (We were expecting the directory with the HPO disease annotation files");
        }
        if (!this.smallFileDirectory.isDirectory()) {
            throw new PhenolRuntimeException(smallFileDirectoryPath + " is not a directory (We were expecting the directory with the HPO disease annotation files");
        }
        this.orphaPhenotypeXMLfile = new File(orphaPhenotypeXMLpath);
        if (!this.orphaPhenotypeXMLfile.exists()) {
            throw new PhenolRuntimeException("Could not find " + this.orphaPhenotypeXMLfile + " (We were expecting the path to en_product4_HPO.xml");
        }
        this.orphaInheritanceXMLfile = new File(orphaInheritanceXMLpath);
        if (!this.orphaInheritanceXMLfile.exists()) {
            throw new PhenolRuntimeException("Could not find " + orphaInheritanceXMLpath + " (We were expecting the path to en_product9_ages.xml");
        }
        this.tolerant = toler;
        this.merge_frequency = merge_fr;
        HpoAnnotationFileIngestor annotationFileIngestor = new HpoAnnotationFileIngestor(this.smallFileDirectory.getAbsolutePath(), ont, this.merge_frequency);
        this.internalAnnotationModelList = annotationFileIngestor.getSmallFileEntries();
        int n_omitted = annotationFileIngestor.get_omitted_entry_count();
        int n_valid_smallfile = annotationFileIngestor.get_valid_smallfile_count();
        this.parseResultAndErrorSummaryLines.add(String.format("[INFO] ommitted small files: %d, valid small files: %d, total: %d", n_omitted, n_valid_smallfile, n_omitted + n_valid_smallfile));
        this.parseResultAndErrorSummaryLines.add(String.format("[INFO] We parsed %d small files/annotation models", this.internalAnnotationModelList.size()));
        if (n_valid_smallfile > this.internalAnnotationModelList.size()) {
            int missing = n_valid_smallfile - this.internalAnnotationModelList.size();
            this.parseResultAndErrorSummaryLines.add(String.format("\n\n[WARNING] Not all valid small files successfully parsed (%d entries missing).\n\n", missing));
        }
        if (n_omitted > 0) {
            logger.trace("{} small files were omitted.", (Object)n_omitted);
        }
        OrphanetInheritanceXMLParser inheritanceXMLParser = new OrphanetInheritanceXMLParser(this.orphaInheritanceXMLfile.getAbsolutePath(), this.ontology);
        this.inheritanceMultiMap = inheritanceXMLParser.getDisease2inheritanceMultimap();
        if (inheritanceXMLParser.hasError()) {
            this.parseResultAndErrorSummaryLines.addAll(inheritanceXMLParser.getErrorlist());
        }
        this.parseResultAndErrorSummaryLines.add(String.format("[INFO] We parsed %d Orphanet inheritance entries", this.inheritanceMultiMap.size()));
        OrphanetXML2HpoDiseaseModelParser orphaParser = new OrphanetXML2HpoDiseaseModelParser(this.orphaPhenotypeXMLfile.getAbsolutePath(), this.ontology, this.tolerant);
        Map<TermId, HpoAnnotationModel> prelimOrphaDiseaseMap = orphaParser.getOrphanetDiseaseMap();
        this.parseResultAndErrorSummaryLines.add(String.format("[INFO] We parsed %d Orphanet disease entries", prelimOrphaDiseaseMap.size()));
        int c = 0;
        for (TermId diseaseId : prelimOrphaDiseaseMap.keySet()) {
            HpoAnnotationModel model = prelimOrphaDiseaseMap.get(diseaseId);
            if (!this.inheritanceMultiMap.containsKey((Object)diseaseId)) continue;
            Collection inheritanceEntryList = this.inheritanceMultiMap.get((Object)diseaseId);
            HpoAnnotationModel mergedModel = model.mergeWithInheritanceAnnotations(inheritanceEntryList);
            prelimOrphaDiseaseMap.put(diseaseId, mergedModel);
            ++c;
        }
        this.parseResultAndErrorSummaryLines.add(String.format("[INFO] We were able to add inheritance information to %d Orphanet disease entries", c));
        this.orphanetSmallFileList = new ArrayList<HpoAnnotationModel>(prelimOrphaDiseaseMap.values());
        this.setOntologyMetadata(ont.getMetaInfo());
        this.setNumberOfDiseasesForHeader();
    }

    private void setNumberOfDiseasesForHeader() {
        this.n_decipher = 0;
        this.n_omim = 0;
        this.n_unknown = 0;
        for (HpoAnnotationModel diseaseModel : this.internalAnnotationModelList) {
            if (diseaseModel.isOMIM()) {
                ++this.n_omim;
                continue;
            }
            if (diseaseModel.isDECIPHER()) {
                ++this.n_decipher;
                continue;
            }
            ++this.n_unknown;
        }
        this.n_orphanet = this.orphanetSmallFileList.size();
    }

    private void setOntologyMetadata(Map<String, String> meta) {
        this.ontologyMetaInfo = meta;
    }

    private String getDate() {
        Date dNow = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        return ft.format(dNow);
    }

    public void outputBigFile() throws IOException {
        String description = String.format("#description: HPO annotations for rare diseases [%d: OMIM; %d: DECIPHER; %d ORPHANET]", this.n_omim, this.n_decipher, this.n_orphanet);
        if (this.n_unknown > 0) {
            description = String.format("%s -- warning: %d entries could not be assigned to a database", description, this.n_unknown);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFileName));
        writer.write(description + "\n");
        writer.write(String.format("#date: %s\n", this.getDate()));
        writer.write("#tracker: https://github.com/obophenotype/human-phenotype-ontology\n");
        if (this.ontologyMetaInfo.containsKey("data-version")) {
            writer.write(String.format("#HPO-version: %s\n", this.ontologyMetaInfo.get("data-version")));
        }
        if (this.ontologyMetaInfo.containsKey("saved-by")) {
            writer.write(String.format("#HPO-contributors: %s\n", this.ontologyMetaInfo.get("saved-by")));
        }
        int n = 0;
        writer.write(PhenotypeDotHpoaFileWriter.getHeaderLine() + "\n");
        for (HpoAnnotationModel smallFile : this.internalAnnotationModelList) {
            List<HpoAnnotationEntry> entryList = smallFile.getEntryList();
            for (HpoAnnotationEntry entry : entryList) {
                try {
                    String bigfileLine = entry.toBigFileLine(this.ontology);
                    writer.write(bigfileLine + "\n");
                }
                catch (HpoAnnotationModelException e) {
                    logger.warn(String.format("[ERROR] with entry (%s) skipping line: %s", e.getMessage(), entry.getLineNoTabs()));
                }
                ++n;
            }
        }
        logger.info("[INFO] We output a total of " + n + " big file lines from internal HPO Annotation files");
        int m = 0;
        HashSet seenInheritance = new HashSet();
        for (HpoAnnotationModel smallFile : this.orphanetSmallFileList) {
            List<HpoAnnotationEntry> entryList = smallFile.getEntryList();
            for (HpoAnnotationEntry entry : entryList) {
                try {
                    String bigfileLine = entry.toBigFileLine(this.ontology);
                    writer.write(bigfileLine + "\n");
                }
                catch (HpoAnnotationModelException e) {
                    logger.warn(String.format("[ERROR] with entry (%s) skipping line: %s", e.getMessage(), entry.getLineNoTabs()));
                }
                ++m;
            }
        }
        logger.info("We output a total of " + m + " big file lines from the Orphanet Annotation files");
        logger.info("Total output lines was " + (n + m));
        for (String line : this.parseResultAndErrorSummaryLines) {
            logger.warn(line);
        }
        writer.close();
    }

    static String getHeaderLine() {
        CharSequence[] fields = new String[]{"DatabaseID", "DiseaseName", "Qualifier", "HPO_ID", "Reference", "Evidence", "Onset", "Frequency", "Sex", "Modifier", "Aspect", "Biocuration"};
        return "#" + String.join((CharSequence)"\t", fields);
    }
}

