/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModelException;
import org.monarchinitiative.phenol.annotations.hpo.ObsoleteTermIdException;
import org.monarchinitiative.phenol.annotations.hpo.OrphanetXML2HpoDiseaseModelParser;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpoAnnotationFileParser {
    private static final Logger logger = LoggerFactory.getLogger(OrphanetXML2HpoDiseaseModelParser.class);
    private final Ontology ontology;
    private final File hpoAnnotationFile;
    private static final String[] expectedFields = new String[]{"#diseaseID", "diseaseName", "phenotypeID", "phenotypeName", "onsetID", "onsetName", "frequency", "sex", "negation", "modifier", "description", "publication", "evidence", "biocuration"};
    private static final int NUMBER_OF_FIELDS = expectedFields.length;
    private List<String> parseErrors;

    public HpoAnnotationFileParser(String path, Ontology ontology) {
        this.hpoAnnotationFile = new File(path);
        this.ontology = ontology;
    }

    public HpoAnnotationFileParser(File file, Ontology ontology) {
        this.hpoAnnotationFile = file;
        this.ontology = ontology;
    }

    public HpoAnnotationModel parse(boolean faultTolerant) throws HpoAnnotationModelException {
        String basename = this.hpoAnnotationFile.getName();
        ArrayList<HpoAnnotationEntry> entryList = new ArrayList<HpoAnnotationEntry>();
        this.parseErrors = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.hpoAnnotationFile));
            String line = br.readLine();
            this.qcHeaderLine(line);
            while ((line = br.readLine()) != null) {
                try {
                    HpoAnnotationEntry entry = HpoAnnotationEntry.fromLine(line, this.ontology);
                    entryList.add(entry);
                }
                catch (ObsoleteTermIdException obsE) {
                    Optional<HpoAnnotationEntry> entryOpt = HpoAnnotationEntry.fromLineReplaceObsoletePhenotypeData(line, this.ontology);
                    entryOpt.ifPresent(entryList::add);
                }
                catch (PhenolException e) {
                    this.parseErrors.add(String.format("%s:%s", this.hpoAnnotationFile, e.getMessage()));
                }
            }
            br.close();
            if (this.parseErrors.size() > 0) {
                String errstr = String.join((CharSequence)"\n", this.parseErrors);
                if (faultTolerant) {
                    logger.warn(String.format("Errors encountered while parsing HPO Annotation file at %s.\n%s", this.hpoAnnotationFile, errstr));
                } else {
                    throw new HpoAnnotationModelException(String.format("Errors encountered while parsing HPO Annotation file at %s.\n%s", this.hpoAnnotationFile, errstr));
                }
            }
            return new HpoAnnotationModel(basename, entryList);
        }
        catch (IOException e) {
            throw new HpoAnnotationModelException(String.format("Error parsing %s: %s", this.hpoAnnotationFile, e.getMessage()));
        }
    }

    public HpoAnnotationModel parse() throws HpoAnnotationModelException {
        return this.parse(false);
    }

    public boolean hasErrors() {
        return this.parseErrors.size() > 0;
    }

    public List<String> getParseErrors() {
        return this.parseErrors;
    }

    private void qcHeaderLine(String line) throws HpoAnnotationModelException {
        String[] fields = line.split("\t");
        if (fields.length != NUMBER_OF_FIELDS) {
            String msg = String.format("Malformed header line\n" + line + "\nExpecting %d fields but got %d", NUMBER_OF_FIELDS, fields.length);
            throw new HpoAnnotationModelException(msg);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].equals(expectedFields[i])) continue;
            throw new HpoAnnotationModelException(String.format("Malformed field %d. Expected %s but got %s", i, expectedFields[i], fields[i]));
        }
    }
}

