/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.mpo;

import com.google.common.collect.ComparisonChain;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class MpoGeneAnnotation
implements TermAnnotation {
    private static final long serialVersionUID = 2L;
    private final TermId geneId;
    private final String entrezGeneSymbol;
    private final String hpoTermName;
    private final TermId hpoTermId;

    public MpoGeneAnnotation(TermId gene, String entrezGeneSymbol, String hpoTermName, TermId hpoTermId) {
        this.geneId = gene;
        this.entrezGeneSymbol = entrezGeneSymbol;
        this.hpoTermName = hpoTermName;
        this.hpoTermId = hpoTermId;
    }

    public TermId getGeneId() {
        return this.geneId;
    }

    public String getGeneSymbol() {
        return this.entrezGeneSymbol;
    }

    public String getTermName() {
        return this.hpoTermName;
    }

    public TermId getTermId() {
        return this.hpoTermId;
    }

    public TermId getLabel() {
        return this.geneId;
    }

    public String toString() {
        return "MPOGeneAnnotation [geneId=" + this.geneId.getValue() + ", entrezGeneSymbol=" + this.entrezGeneSymbol + ", termName=" + this.hpoTermName + ", termId=" + this.hpoTermId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.geneId.hashCode();
        result = 31 * result + (this.entrezGeneSymbol == null ? 0 : this.entrezGeneSymbol.hashCode());
        result = 31 * result + (this.hpoTermId == null ? 0 : this.hpoTermId.hashCode());
        result = 31 * result + (this.hpoTermName == null ? 0 : this.hpoTermName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MpoGeneAnnotation other = (MpoGeneAnnotation)obj;
        if (this.geneId != other.geneId) {
            return false;
        }
        if (this.entrezGeneSymbol == null ? other.entrezGeneSymbol != null : !this.entrezGeneSymbol.equals(other.entrezGeneSymbol)) {
            return false;
        }
        if (this.hpoTermId == null ? other.hpoTermId != null : !this.hpoTermId.equals((Object)other.hpoTermId)) {
            return false;
        }
        return !(this.hpoTermName == null ? other.hpoTermName != null : !this.hpoTermName.equals(other.hpoTermName));
    }

    public int compareTo(TermAnnotation o) {
        if (!(o instanceof HpoGeneAnnotation)) {
            throw new RuntimeException("Cannot compare " + o + " to a HpoGeneAnnotation");
        }
        MpoGeneAnnotation that = (MpoGeneAnnotation)o;
        return ComparisonChain.start().compare((Comparable)this.geneId, (Comparable)that.geneId).compare((Comparable)((Object)this.entrezGeneSymbol), (Comparable)((Object)that.entrezGeneSymbol)).compare((Comparable)((Object)this.hpoTermName), (Comparable)((Object)that.hpoTermName)).compare((Comparable)this.hpoTermId, (Comparable)that.hpoTermId).result();
    }
}

