/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.mpo;

import org.monarchinitiative.phenol.annotations.formats.mpo.MpMarkerType;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpGeneticMarker {
    private final String geneSymbol;
    private final MpMarkerType markerType;
    private final TermId mgiId;

    private MpGeneticMarker(TermId mgiId, String geneSymbol, MpMarkerType markerType) {
        this.mgiId = mgiId;
        this.geneSymbol = geneSymbol;
        this.markerType = markerType;
    }

    public static MpGeneticMarker createMpGeneticMarker(TermId mgiId, String geneSymbol, String markerType, String featureType) {
        MpMarkerType marker = MpMarkerType.string2enum(markerType, featureType);
        return new MpGeneticMarker(mgiId, geneSymbol, marker);
    }

    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public MpMarkerType getMarkerType() {
        return this.markerType;
    }

    public TermId getMgiGeneId() {
        return this.mgiId;
    }

    public boolean isGene() {
        return this.markerType.equals((Object)MpMarkerType.GENE);
    }

    public String toString() {
        return "MpGeneticMarker{mgiId: " + this.mgiId + ", geneSymbol: " + this.geneSymbol + ", markerType: " + (Object)((Object)this.markerType) + '}';
    }
}

