/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.mpo;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpModifier;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpModifierType;
import org.monarchinitiative.phenol.annotations.formats.mpo.MpSex;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class MpAnnotation {
    private final TermId termId;
    private final Set<String> pmidList;
    private final Set<MpModifier> modifiers;

    private MpAnnotation(TermId tid, Set<String> pmids, Set<MpModifier> mods) {
        this.termId = tid;
        this.pmidList = pmids;
        this.modifiers = mods;
    }

    public boolean maleSpecificAbnormal() {
        return this.modifiers.stream().anyMatch(MpModifier::maleSpecific);
    }

    public boolean femaleSpecificAbnormal() {
        return this.modifiers.stream().anyMatch(MpModifier::femaleSpecific);
    }

    public boolean sexSpecific() {
        return this.modifiers.stream().anyMatch(MpModifier::sexSpecific);
    }

    public TermId getTermId() {
        return this.termId;
    }

    public Set<String> getPmidSet() {
        return this.pmidList;
    }

    public Set<MpModifier> getModifiers() {
        return this.modifiers;
    }

    public static MpAnnotation merge(MpAnnotation annot1, MpAnnotation annot2) throws PhenolException {
        if (!annot1.termId.equals((Object)annot2.termId)) {
            throw new PhenolException(String.format("Attempt to merge annotations with distinct MP ids [%s/%s]", annot1.termId.getValue(), annot2.termId.getValue()));
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(annot1.getPmidSet());
        builder.addAll(annot2.getPmidSet());
        ImmutableSet.Builder modbuilder = new ImmutableSet.Builder();
        modbuilder.addAll(annot1.getModifiers());
        modbuilder.addAll(annot2.getModifiers());
        return new MpAnnotation(annot1.termId, (Set<String>)builder.build(), (Set<MpModifier>)modbuilder.build());
    }

    public String toString() {
        return this.termId.getValue() + this.modifiers.stream().map(MpModifier::getType).map(Enum::toString).collect(Collectors.joining("; "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpAnnotation that = (MpAnnotation)o;
        if (!this.termId.equals((Object)that.termId)) {
            return false;
        }
        if (this.pmidList != null ? !this.pmidList.equals(that.pmidList) : that.pmidList != null) {
            return false;
        }
        return this.modifiers.equals(that.modifiers);
    }

    public int hashCode() {
        int result = this.termId.hashCode();
        result = 31 * result + (this.pmidList != null ? this.pmidList.hashCode() : 0);
        result = 31 * result + this.modifiers.hashCode();
        return result;
    }

    public static class Builder {
        private final TermId termId;
        private final Set<String> pmidList;
        private Set<MpModifier> modifers;

        public Builder(TermId tid, Set<String> pmids) {
            Objects.requireNonNull(tid, "TermId cannot be null");
            this.termId = tid;
            this.pmidList = pmids;
            this.modifers = new HashSet<MpModifier>();
        }

        public Builder sexSpecific(MpSex sex) {
            if (sex.equals((Object)MpSex.FEMALE)) {
                this.modifers.add(new MpModifier(MpModifierType.FEMALE_SPECIFIC_ABNORMAL));
            } else if (sex.equals((Object)MpSex.MALE)) {
                this.modifers.add(new MpModifier(MpModifierType.MALE_SPECIFIC_ABNORMAL));
            }
            return this;
        }

        public Builder sexSpecificNormal(MpSex sex) {
            if (sex.equals((Object)MpSex.FEMALE)) {
                this.modifers.add(new MpModifier(MpModifierType.FEMALE_SPECIFIC_NORMAL));
            } else if (sex.equals((Object)MpSex.MALE)) {
                this.modifers.add(new MpModifier(MpModifierType.MALE_SPECIFIC_NORMAL));
            }
            return this;
        }

        public Builder modifiers(Set<MpModifier> modset) {
            this.modifers = modset;
            return this;
        }

        public MpAnnotation build() {
            return new MpAnnotation(this.termId, (Set)ImmutableSet.copyOf(this.pmidList), (Set)ImmutableSet.copyOf(this.modifers));
        }
    }
}

