/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.go;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class GoGaf21Annotation
implements TermAnnotation {
    private static final long serialVersionUID = 2L;
    private final TermId dbObjectTermId;
    private final String dbObjectSymbol;
    private final String qualifier;
    private final TermId goId;
    private final String dbReference;
    private final String evidenceCode;
    private final String with;
    private final String aspect;
    private final String dbObjectName;
    private final String dbObjectSynonym;
    private final String dbObjectType;
    private final List<String> taxons;
    private final Date date;
    private final String assignedBy;
    private final String annotationExtension;
    private final String geneProductFormId;

    private GoGaf21Annotation(String[] arr) throws PhenolException {
        this.dbObjectTermId = arr[1].contains(":") ? TermId.of((String)arr[1]) : TermId.of((String)arr[0], (String)arr[1]);
        this.dbObjectSymbol = arr[2];
        this.qualifier = arr[3];
        this.goId = TermId.of((String)arr[4]);
        this.dbReference = arr[5];
        this.evidenceCode = arr[6];
        this.with = arr[7];
        this.aspect = arr[8];
        this.dbObjectName = arr[9];
        this.dbObjectSynonym = arr[10];
        this.dbObjectType = arr[11];
        this.taxons = ImmutableList.copyOf((Object[])arr[12].split("\\|"));
        String dateStr = arr[13];
        this.assignedBy = arr[14];
        this.annotationExtension = arr.length < 16 ? null : arr[15];
        this.geneProductFormId = arr.length < 17 ? null : arr[16];
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            this.date = format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new PhenolException("There was a problem parsing the date value " + dateStr, (Throwable)e);
        }
    }

    public static GoGaf21Annotation parseAnnotation(String line) throws PhenolException {
        CharSequence[] arr = line.split("\t");
        if (arr.length < 15 || arr.length > 17) {
            throw new PhenolException("GAF line had " + arr.length + " columns, but expected between 15 and 17 entries. \n Line was:" + String.join((CharSequence)"\t", arr));
        }
        return new GoGaf21Annotation((String[])arr);
    }

    public String getDb() {
        return this.dbObjectTermId.getPrefix();
    }

    public String getDbObjectId() {
        return this.dbObjectTermId.getId();
    }

    public TermId getDbObjectTermId() {
        return this.dbObjectTermId;
    }

    public String getDbObjectSymbol() {
        return this.dbObjectSymbol;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public TermId getGoId() {
        return this.goId;
    }

    public String getDbReference() {
        return this.dbReference;
    }

    public Optional<String> getEvidenceCode() {
        return Optional.ofNullable(this.evidenceCode);
    }

    public String getWith() {
        return this.with;
    }

    public String getAspect() {
        return this.aspect;
    }

    public String getDbObjectName() {
        return this.dbObjectName;
    }

    public String getDbObjectSynonym() {
        return this.dbObjectSynonym;
    }

    public String getDbObjectType() {
        return this.dbObjectType;
    }

    public List<String> getTaxons() {
        return this.taxons;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAssignedBy() {
        return this.assignedBy;
    }

    public String getAnnotationExtension() {
        return this.annotationExtension;
    }

    public String getGeneProductFormId() {
        return this.geneProductFormId;
    }

    public TermId getTermId() {
        return this.goId;
    }

    public TermId getLabel() {
        return this.dbObjectTermId;
    }

    public int compareTo(TermAnnotation o) {
        if (!(o instanceof GoGaf21Annotation)) {
            throw new PhenolRuntimeException("Can only compare GoGaf21Annotation with objects of same type");
        }
        GoGaf21Annotation that = (GoGaf21Annotation)o;
        return ComparisonChain.start().compare((Comparable)((Object)this.annotationExtension), (Comparable)((Object)that.annotationExtension)).compare((Comparable)((Object)this.aspect), (Comparable)((Object)that.aspect)).compare((Comparable)((Object)this.assignedBy), (Comparable)((Object)that.assignedBy)).compare((Comparable)this.date, (Comparable)that.date).compare((Comparable)this.dbObjectTermId, (Comparable)that.dbObjectTermId).compare((Comparable)((Object)this.dbObjectName), (Comparable)((Object)that.dbObjectName)).compare((Comparable)((Object)this.dbObjectSymbol), (Comparable)((Object)that.dbObjectSymbol)).compare((Comparable)((Object)this.dbObjectSynonym), (Comparable)((Object)that.dbObjectSynonym)).compare((Comparable)((Object)this.dbObjectType), (Comparable)((Object)that.dbObjectType)).compare((Comparable)((Object)this.dbReference), (Comparable)((Object)that.dbReference)).compare((Comparable)((Object)this.evidenceCode), (Comparable)((Object)that.evidenceCode)).compare((Comparable)((Object)this.geneProductFormId), (Comparable)((Object)that.geneProductFormId)).compare((Comparable)this.goId, (Comparable)that.goId).compare((Comparable)((Object)this.qualifier), (Comparable)((Object)that.qualifier)).compare(this.taxons, that.taxons, (Comparator)Ordering.natural().lexicographical()).compare((Comparable)((Object)this.with), (Comparable)((Object)that.with)).result();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationExtension == null ? 0 : this.annotationExtension.hashCode());
        result = 31 * result + (this.aspect == null ? 0 : this.aspect.hashCode());
        result = 31 * result + (this.assignedBy == null ? 0 : this.assignedBy.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.dbObjectTermId == null ? 0 : this.dbObjectTermId.hashCode());
        result = 31 * result + (this.dbObjectName == null ? 0 : this.dbObjectName.hashCode());
        result = 31 * result + (this.dbObjectSymbol == null ? 0 : this.dbObjectSymbol.hashCode());
        result = 31 * result + (this.dbObjectSynonym == null ? 0 : this.dbObjectSynonym.hashCode());
        result = 31 * result + (this.dbObjectType == null ? 0 : this.dbObjectType.hashCode());
        result = 31 * result + (this.dbReference == null ? 0 : this.dbReference.hashCode());
        result = 31 * result + (this.evidenceCode == null ? 0 : this.evidenceCode.hashCode());
        result = 31 * result + (this.geneProductFormId == null ? 0 : this.geneProductFormId.hashCode());
        result = 31 * result + (this.goId == null ? 0 : this.goId.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.taxons == null ? 0 : this.taxons.hashCode());
        result = 31 * result + (this.with == null ? 0 : this.with.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoGaf21Annotation other = (GoGaf21Annotation)obj;
        if (this.annotationExtension == null ? other.annotationExtension != null : !this.annotationExtension.equals(other.annotationExtension)) {
            return false;
        }
        if (this.aspect == null ? other.aspect != null : !this.aspect.equals(other.aspect)) {
            return false;
        }
        if (this.assignedBy == null ? other.assignedBy != null : !this.assignedBy.equals(other.assignedBy)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.dbObjectTermId == null ? other.dbObjectTermId != null : !this.dbObjectTermId.equals((Object)other.dbObjectTermId)) {
            return false;
        }
        if (this.dbObjectName == null ? other.dbObjectName != null : !this.dbObjectName.equals(other.dbObjectName)) {
            return false;
        }
        if (this.dbObjectSymbol == null ? other.dbObjectSymbol != null : !this.dbObjectSymbol.equals(other.dbObjectSymbol)) {
            return false;
        }
        if (this.dbObjectSynonym == null ? other.dbObjectSynonym != null : !this.dbObjectSynonym.equals(other.dbObjectSynonym)) {
            return false;
        }
        if (this.dbObjectType == null ? other.dbObjectType != null : !this.dbObjectType.equals(other.dbObjectType)) {
            return false;
        }
        if (this.dbReference == null ? other.dbReference != null : !this.dbReference.equals(other.dbReference)) {
            return false;
        }
        if (this.evidenceCode == null ? other.evidenceCode != null : !this.evidenceCode.equals(other.evidenceCode)) {
            return false;
        }
        if (this.geneProductFormId == null ? other.geneProductFormId != null : !this.geneProductFormId.equals(other.geneProductFormId)) {
            return false;
        }
        if (this.goId == null ? other.goId != null : !this.goId.equals((Object)other.goId)) {
            return false;
        }
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        if (this.taxons == null ? other.taxons != null : !this.taxons.equals(other.taxons)) {
            return false;
        }
        return !(this.with == null ? other.with != null : !this.with.equals(other.with));
    }

    public String toString() {
        return "GoGaf21Annotation [db=" + this.dbObjectTermId.getPrefix() + ", dbObjectId=" + this.dbObjectTermId.getId() + ", dbObjectSymbol=" + this.dbObjectSymbol + ", qualifier=" + this.qualifier + ", goId=" + this.goId + ", dbReference=" + this.dbReference + ", evidenceCode=" + this.evidenceCode + ", with=" + this.with + ", aspect=" + this.aspect + ", dbObjectName=" + this.dbObjectName + ", dbObjectSynonym=" + this.dbObjectSynonym + ", dbObjectType=" + this.dbObjectType + ", taxons=" + this.taxons + ", date=" + this.date + ", assignedBy=" + this.assignedBy + ", annotationExtension=" + this.annotationExtension + ", geneProductFormId=" + this.geneProductFormId + "]";
    }
}

