/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.assoc.Gene2DiseaseAssociationParser;
import org.monarchinitiative.phenol.annotations.formats.Gene;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.annotations.obo.hpo.HpoDiseaseAnnotationParser;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAssociationParser {
    private final Ontology hpoOntology;
    private final File homoSapiensGeneInfoFile;
    private final File mim2geneMedgenFile;
    private final File orphaToGeneFile;
    private final File phenotypeDotHpoaFile;
    private Map<TermId, String> geneIdToSymbolMap;
    private ImmutableMultimap<TermId, TermId> diseaseToGeneMap;
    private ImmutableMultimap<TermId, TermId> geneToDiseaseMap;
    private ImmutableMap<TermId, DiseaseToGeneAssociation> diseaseToAssociationsMap;
    private ImmutableList<HpoGeneAnnotation> phenotypeToGeneList;
    private List<DiseaseToGeneAssociation> associationList;

    public HpoAssociationParser(String geneInfoPath, String mim2geneMedgenPath, String orphaToGenePath, String phenotypeHpoaPath, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoFile = new File(geneInfoPath);
        this.mim2geneMedgenFile = new File(mim2geneMedgenPath);
        this.orphaToGeneFile = new File(orphaToGenePath);
        this.phenotypeDotHpoaFile = new File(phenotypeHpoaPath);
        this.ingestDisease2GeneAssociations();
        this.ingestPhenotypeHpoaFile();
    }

    public HpoAssociationParser(String geneInfoPath, String mim2geneMedgenPath, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoFile = new File(geneInfoPath);
        this.mim2geneMedgenFile = new File(mim2geneMedgenPath);
        this.orphaToGeneFile = null;
        this.phenotypeDotHpoaFile = null;
        this.ingestDisease2GeneAssociations();
    }

    public HpoAssociationParser(File geneInfoFile, File mim2geneMedgenFile, File phenotypeHpoaFile, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoFile = geneInfoFile;
        this.mim2geneMedgenFile = mim2geneMedgenFile;
        this.orphaToGeneFile = null;
        this.phenotypeDotHpoaFile = phenotypeHpoaFile;
        this.ingestDisease2GeneAssociations();
        this.ingestPhenotypeHpoaFile();
    }

    public HpoAssociationParser(File geneInfoFile, File mim2geneMedgenFile, File orphaToGeneFile, File phenotypeHpoaFile, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoFile = geneInfoFile;
        this.mim2geneMedgenFile = mim2geneMedgenFile;
        this.orphaToGeneFile = orphaToGeneFile;
        this.phenotypeDotHpoaFile = phenotypeHpoaFile;
        this.ingestDisease2GeneAssociations();
        this.ingestPhenotypeHpoaFile();
    }

    private void ingestPhenotypeHpoaFile() {
        if (!this.phenotypeDotHpoaFile.exists()) {
            throw new PhenolRuntimeException("Cannot find phenotype.hpoa file");
        }
        ImmutableList desiredDatabasePrefixes = ImmutableList.of((Object)"OMIM");
        Map<TermId, HpoDisease> diseaseMap = HpoDiseaseAnnotationParser.loadDiseaseMap(this.phenotypeDotHpoaFile.getAbsolutePath(), this.hpoOntology, (List<String>)desiredDatabasePrefixes);
        ArrayListMultimap phenotypeToDisease = ArrayListMultimap.create();
        for (Map.Entry<TermId, HpoDisease> entry : diseaseMap.entrySet()) {
            for (HpoAnnotation hpoAnnot : entry.getValue().getPhenotypicAbnormalities()) {
                TermId hpoId = hpoAnnot.getTermId();
                phenotypeToDisease.put((Object)hpoId, (Object)entry.getKey());
            }
        }
        this.setTermToGene((Multimap<TermId, TermId>)phenotypeToDisease);
    }

    public Map<TermId, DiseaseToGeneAssociation> getDiseaseToAssociationsMap() {
        return this.diseaseToAssociationsMap;
    }

    public Map<TermId, String> getGeneIdToSymbolMap() {
        return this.geneIdToSymbolMap;
    }

    public Multimap<TermId, TermId> getDiseaseToGeneIdMap() {
        return this.diseaseToGeneMap;
    }

    public Multimap<TermId, TermId> getGeneToDiseaseIdMap() {
        return this.geneToDiseaseMap;
    }

    public List<HpoGeneAnnotation> getPhenotypeToGene() {
        return this.phenotypeToGeneList;
    }

    public void setTermToGene(Multimap<TermId, TermId> phenotypeToDisease) {
        if (this.diseaseToGeneMap.isEmpty()) {
            throw new PhenolRuntimeException("Error: Associations not parsed. Please call parse then set the term to gene mapping.");
        }
        ImmutableList.Builder builderGeneAnnotationList = new ImmutableList.Builder();
        for (TermId phenotype : phenotypeToDisease.keySet()) {
            HashSet mappedGenes = new HashSet();
            phenotypeToDisease.get((Object)phenotype).stream().flatMap(disease -> this.diseaseToGeneMap.get(disease).stream()).collect(Collectors.toList()).forEach(gene -> {
                try {
                    int entrezId = Integer.parseInt(gene.getId());
                    if (!mappedGenes.contains(gene)) {
                        String entrezGeneSymbol = this.geneIdToSymbolMap.get(gene);
                        if (entrezGeneSymbol == null) {
                            entrezGeneSymbol = "-";
                        }
                        String hpoTermName = ((Term)this.hpoOntology.getTermMap().get(phenotype)).getName();
                        HpoGeneAnnotation geneAnnotation = new HpoGeneAnnotation(entrezId, entrezGeneSymbol, hpoTermName, phenotype);
                        builderGeneAnnotationList.add((Object)geneAnnotation);
                        mappedGenes.add(gene);
                    }
                }
                catch (Exception e) {
                    System.err.println("[ERROR] setTermToGene encountered an exception: " + e.getMessage() + " for gene: " + gene.toString());
                }
            });
        }
        this.phenotypeToGeneList = builderGeneAnnotationList.build();
    }

    private void setAssociationMaps() {
        ArrayListMultimap geneToDisease = ArrayListMultimap.create();
        ImmutableMap.Builder builderDiseasetoAssociation = new ImmutableMap.Builder();
        for (DiseaseToGeneAssociation g2p : this.associationList) {
            TermId diseaseId = g2p.getDiseaseId();
            List<Gene> geneList = g2p.getGeneList();
            builderDiseasetoAssociation.put((Object)diseaseId, (Object)g2p);
            for (Gene g : geneList) {
                TermId geneId = g.getId();
                if (geneToDisease.containsEntry((Object)geneId, (Object)diseaseId)) continue;
                geneToDisease.put((Object)geneId, (Object)diseaseId);
            }
        }
        ImmutableMultimap.Builder builderGeneToDisease = new ImmutableMultimap.Builder();
        builderGeneToDisease.putAll((Multimap)geneToDisease);
        this.geneToDiseaseMap = builderGeneToDisease.build();
        this.diseaseToGeneMap = builderGeneToDisease.build().inverse();
        this.diseaseToAssociationsMap = builderDiseasetoAssociation.build();
    }

    private void ingestDisease2GeneAssociations() {
        Gene2DiseaseAssociationParser parser = this.orphaToGeneFile != null ? new Gene2DiseaseAssociationParser(this.homoSapiensGeneInfoFile, this.mim2geneMedgenFile, this.orphaToGeneFile) : new Gene2DiseaseAssociationParser(this.homoSapiensGeneInfoFile, this.mim2geneMedgenFile);
        Multimap<TermId, GeneToAssociation> associationMap = parser.getAssociationMap();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (TermId omimCurie : associationMap.keySet()) {
            Collection g2aList = associationMap.get((Object)omimCurie);
            DiseaseToGeneAssociation g2p = new DiseaseToGeneAssociation(omimCurie, (List<GeneToAssociation>)ImmutableList.copyOf((Collection)g2aList));
            builder.add((Object)g2p);
        }
        this.associationList = builder.build();
        this.geneIdToSymbolMap = parser.getGeneIdToSymbolMap();
        this.setAssociationMaps();
    }
}

