/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GeneInfoParser {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";

    private GeneInfoParser() {
    }

    public static Map<TermId, String> loadGeneIdToSymbolMap(String geneInfoPath) {
        if (geneInfoPath == null) {
            throw new PhenolRuntimeException("Attempt to loadGeneIdToSymbolMap with null value for geneInfoPath");
        }
        return GeneInfoParser.loadGeneIdToSymbolMap(new File(geneInfoPath));
    }

    public static Map<TermId, String> loadGeneIdToSymbolMap(File geneInfoFile) {
        if (!geneInfoFile.exists()) {
            throw new PhenolRuntimeException("Could not find Homo_sapiens.gene_info.gz");
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        try {
            String line;
            FileInputStream fileStream = new FileInputStream(geneInfoFile);
            GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
            InputStreamReader decoder = new InputStreamReader(gzipStream);
            BufferedReader br = new BufferedReader(decoder);
            HashSet<TermId> seen = new HashSet<TermId>();
            while ((line = br.readLine()) != null) {
                String[] a = line.split("\t");
                String taxon = a[0];
                if (!taxon.equals("9606") || "unknown".equals(a[9])) continue;
                String geneId = a[1];
                String symbol = a[2];
                TermId tid = TermId.of((String)ENTREZ_GENE_PREFIX, (String)geneId);
                if (seen.contains(tid)) continue;
                seen.add(tid);
                builder.put((Object)tid, (Object)symbol);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PhenolRuntimeException("IOException encountered when trying to read Homo_sapiens.gene_info.gz.");
        }
        return builder.build();
    }
}

