/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoParser;
import org.monarchinitiative.phenol.annotations.assoc.OrphaGeneToDiseaseParser;
import org.monarchinitiative.phenol.annotations.formats.Gene;
import org.monarchinitiative.phenol.annotations.formats.hpo.AssociationType;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class Gene2DiseaseAssociationParser {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private static final String OMIM_PREFIX = "OMIM";
    private Map<TermId, String> allGeneIdToSymbolMap;
    private ImmutableMap<TermId, String> geneIdToSymbolMap;
    private Multimap<TermId, GeneToAssociation> associationMap;

    Gene2DiseaseAssociationParser(String homoSapiensGeneInfo, String mim2geneMedgen) {
        this(new File(homoSapiensGeneInfo), new File(mim2geneMedgen));
    }

    Gene2DiseaseAssociationParser(File homoSapiensGeneInfoFile, File mim2geneMedgenFile) {
        this.parseMim2geneAndGeneInfo(homoSapiensGeneInfoFile, mim2geneMedgenFile);
    }

    Gene2DiseaseAssociationParser(String homoSapiensGeneInfo, String mim2geneMedgen, String orphanet2Gene) {
        this(new File(homoSapiensGeneInfo), new File(mim2geneMedgen), new File(orphanet2Gene));
    }

    Gene2DiseaseAssociationParser(File homoSapiensGeneInfoFile, File mim2geneMedgenFile, File orphanet2GeneFile) {
        this.parseMim2geneAndGeneInfo(homoSapiensGeneInfoFile, mim2geneMedgenFile);
        if (!orphanet2GeneFile.exists()) {
            throw new PhenolRuntimeException("Cannot find Orphanet en_product6.xml file");
        }
        this.parseOrphaToGene(orphanet2GeneFile, mim2geneMedgenFile);
    }

    private void parseMim2geneAndGeneInfo(File homoSapiensGeneInfoFile, File mim2geneMedgenFile) {
        if (!homoSapiensGeneInfoFile.exists()) {
            throw new PhenolRuntimeException("Cannot find Homo_sapiens.gene_info.gz file at \"" + homoSapiensGeneInfoFile + "\"");
        }
        if (!mim2geneMedgenFile.exists()) {
            throw new PhenolRuntimeException("Cannot find mim2gene_medgen file at \"" + mim2geneMedgenFile + "\"");
        }
        this.allGeneIdToSymbolMap = GeneInfoParser.loadGeneIdToSymbolMap(homoSapiensGeneInfoFile);
        try {
            this.parseMim2GeneMedgen(mim2geneMedgenFile);
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Could not parse mim2gene_medgen: " + mim2geneMedgenFile.getAbsolutePath());
        }
    }

    public Multimap<TermId, GeneToAssociation> getAssociationMap() {
        ImmutableMultimap.Builder associationBuilder = new ImmutableMultimap.Builder();
        associationBuilder.putAll(this.associationMap);
        return associationBuilder.build();
    }

    public Map<TermId, String> getGeneIdToSymbolMap() {
        return this.geneIdToSymbolMap;
    }

    private void parseOrphaToGene(File orphaToGeneFile, File mim2geneMedgenFile) {
        OrphaGeneToDiseaseParser parser = new OrphaGeneToDiseaseParser(orphaToGeneFile, mim2geneMedgenFile);
        Multimap<TermId, Gene> orphaToGene = parser.getOrphaDiseaseToGeneSymbolMap();
        int size_before = this.associationMap.size();
        for (Map.Entry entry : orphaToGene.entries()) {
            TermId orpha = (TermId)entry.getKey();
            Gene gene = (Gene)entry.getValue();
            GeneToAssociation g2a = new GeneToAssociation(gene, AssociationType.UNKNOWN);
            this.associationMap.put((Object)orpha, (Object)g2a);
        }
        int size_after = this.associationMap.size();
        int added = size_after - size_before;
        System.out.printf("Added %d Orphanet entries to association map (total size: %d).\n", added, size_after);
    }

    public void parseMim2GeneMedgen(File mim2geneMedgenFile) throws IOException {
        ArrayListMultimap associationMap = ArrayListMultimap.create();
        HashMap<TermId, String> geneMap = new HashMap<TermId, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(mim2geneMedgenFile));){
            String line;
            while ((line = br.readLine()) != null) {
                GeneToAssociation g2a;
                String[] associations;
                if (line.startsWith("#") || !(associations = line.split("\t"))[2].equals("phenotype")) continue;
                String mimid = associations[0];
                TermId omimCurie = TermId.of((String)OMIM_PREFIX, (String)mimid);
                String entrezGeneNumber = associations[1];
                TermId entrezId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                String symbol = this.allGeneIdToSymbolMap.get(entrezId);
                if ("-".equals(entrezGeneNumber)) continue;
                if (symbol == null) {
                    symbol = "-";
                } else if (!geneMap.containsKey(entrezId)) {
                    geneMap.put(entrezId, symbol);
                }
                TermId geneId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                Gene gene = new Gene(geneId, symbol);
                if (associations[5].contains("susceptibility")) {
                    g2a = new GeneToAssociation(gene, AssociationType.POLYGENIC);
                    if (associationMap.containsEntry((Object)omimCurie, (Object)g2a)) continue;
                    associationMap.put((Object)omimCurie, (Object)g2a);
                    continue;
                }
                g2a = new GeneToAssociation(gene, AssociationType.MENDELIAN);
                if (associationMap.containsEntry((Object)omimCurie, (Object)g2a)) continue;
                associationMap.put((Object)omimCurie, (Object)g2a);
            }
        }
        this.associationMap = associationMap;
        ImmutableMap.Builder geneBuilder = new ImmutableMap.Builder();
        geneBuilder.putAll(geneMap);
        this.geneIdToSymbolMap = geneBuilder.build();
    }
}

