/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.analysis.ItemAnnotations;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class Util {
    public static Set<TermId> getDomainItemsAnnotatedByOntologyTerm(TermId termId, MinimalOntology ontology, Map<TermId, ? extends ItemAnnotations<TermId>> gene2associationMap) {
        HashSet<TermId> domainItemSet = new HashSet<TermId>();
        Set descendentSet = ontology.graph().getDescendantsStream((Object)termId, true).collect(Collectors.toSet());
        for (Map.Entry<TermId, ? extends ItemAnnotations<TermId>> entry : gene2associationMap.entrySet()) {
            TermId gene = entry.getKey();
            for (TermId ontologyTermId : entry.getValue().getAnnotatingTermIds()) {
                if (!descendentSet.contains(ontologyTermId) && !ontologyTermId.equals((Object)termId)) continue;
                domainItemSet.add(gene);
            }
        }
        return domainItemSet;
    }
}

