/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats;

import java.util.Vector;

public class Hypergeometric {
    private final Vector<Double> lfactorial = new Vector();

    public Hypergeometric() {
        this.lfactorial.add(0, 0.0);
        this.lfactorial.add(1, 0.0);
    }

    public double phypergeometric(int n, double p, int k, int r) {
        if (k >= n) {
            return 1.0;
        }
        if (r < 1) {
            return 1.0;
        }
        double q = 1.0 - p;
        int np = (int)Math.round((double)n * p);
        int nq = (int)Math.round((double)n * q);
        double log_n_choose_k = this.lNchooseK(n, k);
        int top = Math.min(np, k);
        double lfoo = this.lNchooseK(np, top) + this.lNchooseK(nq, k - top);
        double sum = 0.0;
        for (int i = top; i >= r; --i) {
            sum += Math.exp(lfoo - log_n_choose_k);
            if (i <= r) continue;
            lfoo = lfoo + Math.log((double)i / (double)(np - i + 1)) + Math.log((double)(nq - k + i) / (double)(k - i + 1));
        }
        return sum;
    }

    public double phypergeometric(int m, int m_t, int n, int n_t) {
        if (n >= m) {
            return 1.0;
        }
        if (n_t < 1) {
            return 1.0;
        }
        if (m_t > m) {
            return 1.0;
        }
        int nq = m - m_t;
        double log_n_choose_k = this.lNchooseK(m, n);
        int top = Math.min(m_t, n);
        double lfoo = this.lNchooseK(m_t, top) + this.lNchooseK(nq, n - top);
        double sum = 0.0;
        for (int i = top; i >= n_t; --i) {
            sum += Math.exp(lfoo - log_n_choose_k);
            if (i <= n_t) continue;
            lfoo = lfoo + Math.log((double)i / (double)(m_t - i + 1)) + Math.log((double)(nq - n + i) / (double)(n - i + 1));
        }
        return sum;
    }

    public double dhyper(int x, int N, int M, int n) {
        if (x > M) {
            return 0.0;
        }
        if (x > n) {
            return 0.0;
        }
        if (n - x > N - M) {
            return 0.0;
        }
        return Math.exp(this.lNchooseK(M, x) + this.lNchooseK(N - M, n - x) - this.lNchooseK(N, n));
    }

    public double phyper(int x, int N, int M, int n, boolean lowerTail) {
        int up = Math.min(n, M);
        double p = 0.0;
        if (x < up / 2) {
            for (int i = x; i >= 0; --i) {
                p += this.dhyper(i, N, M, n);
            }
            if (lowerTail) {
                return p;
            }
            return 1.0 - p;
        }
        for (int i = x + 1; i <= up; ++i) {
            p += this.dhyper(i, N, M, n);
        }
        if (lowerTail) {
            return 1.0 - p;
        }
        return p;
    }

    public double lNchooseK(int n, int k) {
        double ans = this.logfact(n) - this.logfact(k) - this.logfact(n - k);
        return ans;
    }

    public double logfact(int i) {
        if (i > this.lfactorial.size() - 1) {
            for (int j = this.lfactorial.size(); j <= i; ++j) {
                double lf = this.lfactorial.get(j - 1) + Math.log(j);
                this.lfactorial.add(j, lf);
            }
        }
        return this.lfactorial.get(i);
    }
}

