/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.scoredist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.monarchinitiative.phenol.analysis.scoredist.ObjHexStringConverter;
import org.monarchinitiative.phenol.analysis.scoredist.ScoreDistributionReader;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.scoredist.ObjectScoreDistribution;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreDistribution;

public class TextFileScoreDistributionReader
implements ScoreDistributionReader {
    private final File inputFile;
    private final BufferedReader reader;
    private String nextLine;

    public TextFileScoreDistributionReader(File inputFile) throws PhenolException {
        this.inputFile = inputFile;
        try {
            this.reader = new BufferedReader(new FileReader(this.inputFile));
            this.readHeader();
        }
        catch (IOException e) {
            throw new PhenolException("Problem initializing reader for file " + String.valueOf(inputFile));
        }
    }

    private void readHeader() throws IOException {
        this.nextLine = this.reader.readLine();
        if (this.nextLine == null) {
            throw new IOException("Could not read header from file!");
        }
        String expected = "#numTerms\tentrezId\tsampleSize\tdistribution";
        if (!"#numTerms\tentrezId\tsampleSize\tdistribution".equals(this.nextLine)) {
            throw new IOException("Invalid header, was: \"" + this.nextLine + "\", expected: \"#numTerms\tentrezId\tsampleSize\tdistribution\"");
        }
        this.nextLine = this.reader.readLine();
    }

    @Override
    public ScoreDistribution readForTermCount(int termCount) throws PhenolException {
        Map<Integer, ScoreDistribution> allDists = this.readAll();
        if (!allDists.containsKey(termCount)) {
            throw new PhenolException("Distribution not found for term count: " + termCount);
        }
        return allDists.get(termCount);
    }

    @Override
    public Map<Integer, ScoreDistribution> readAll() throws PhenolException {
        HashMap<Integer, ScoreDistribution> result = new HashMap<Integer, ScoreDistribution>();
        HashMap tmp = new HashMap();
        while (this.nextLine != null) {
            TermId entrezId;
            String[] arr = this.nextLine.trim().split("\t");
            int numTerms = Integer.parseInt(arr[0]);
            try {
                entrezId = (TermId)ObjHexStringConverter.hex2obj(arr[1]);
            }
            catch (IOException | ClassNotFoundException | DecoderException e) {
                throw new PhenolException("Failed to parse hexadecimal string to object: " + arr[1]);
            }
            int sampleSize = Integer.parseInt(arr[2]);
            String dist = arr[3];
            TreeMap<Double, Double> cumFreqs = new TreeMap<Double, Double>();
            for (String pairStr : dist.split(",")) {
                String[] pair = pairStr.split(":");
                cumFreqs.put(Double.parseDouble(pair[0]), Double.parseDouble(pair[1]));
            }
            ObjectScoreDistribution scoreDist = new ObjectScoreDistribution(entrezId, numTerms, sampleSize, cumFreqs);
            if (!tmp.containsKey(numTerms)) {
                tmp.put(numTerms, new TreeMap());
            }
            ((Map)tmp.get(numTerms)).put(entrezId, scoreDist);
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new PhenolException("Could not load score distributions", (Throwable)e);
            }
        }
        for (Map.Entry e : tmp.entrySet()) {
            int numTerms = (Integer)e.getKey();
            result.put(numTerms, new ScoreDistribution(numTerms, (Map)e.getValue()));
        }
        return result;
    }

    @Override
    public ObjectScoreDistribution readForTermCountAndObject(int termCount, TermId objectId) throws PhenolException {
        ObjectScoreDistribution result = this.readForTermCount(termCount).getObjectScoreDistribution(objectId);
        if (result == null) {
            throw new PhenolException("Distribution not found for term count: " + termCount + " and object ID: " + String.valueOf(objectId));
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

