/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import java.util.Random;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaScoreBase;

public abstract class MgsaScore
extends MgsaScoreBase {
    protected Random rnd;
    protected double[] observedValueOfGene;
    protected int numRecords;
    protected int[] termActivationCounts;
    protected boolean usePrior = true;
    protected double p = Double.NaN;

    public MgsaScore(Random rnd, int[][] termLinks, int numGenes, IGeneValueProvider geneValueProvider) {
        super(termLinks, numGenes);
        this.rnd = rnd;
        double threshold = geneValueProvider.getThreshold();
        boolean smallerIsBetter = geneValueProvider.smallerIsBetter();
        this.observedValueOfGene = new double[numGenes];
        for (int i = 0; i < numGenes; ++i) {
            this.observedValueOfGene[i] = geneValueProvider.getGeneValue(i);
            this.observedGenes[i] = smallerIsBetter ? this.observedValueOfGene[i] <= threshold : this.observedValueOfGene[i] >= threshold;
        }
        this.termActivationCounts = new int[this.numTerms];
    }

    public MgsaScore(Random rnd, int[][] termLinks, final boolean[] observedGenes) {
        this(rnd, termLinks, observedGenes.length, new IGeneValueProvider(){

            @Override
            public boolean smallerIsBetter() {
                return true;
            }

            @Override
            public double getThreshold() {
                return 0.0;
            }

            @Override
            public double getGeneValue(int gid) {
                if (observedGenes[gid]) {
                    return -1.0;
                }
                return 1.0;
            }
        });
    }

    public void setUsePrior(boolean usePrior) {
        this.usePrior = usePrior;
    }

    public boolean getUsePrior() {
        return this.usePrior;
    }

    public void setExpectedNumberOfTerms(double terms) {
        this.p = terms / (double)this.numTerms;
    }

    public double score(int[] activeTerms) {
        int[] oldTerms = new int[this.numTerms - this.numInactiveTerms];
        int i = this.numInactiveTerms;
        int j = 0;
        while (i < this.numTerms) {
            oldTerms[j] = this.termPartition[i];
            ++i;
            ++j;
        }
        for (int oldTerm : oldTerms) {
            this.switchState(oldTerm);
        }
        for (int idx : activeTerms) {
            this.switchState(idx);
        }
        double score = this.getScore();
        for (int idx : activeTerms) {
            this.switchState(idx);
        }
        for (int oldTerm : oldTerms) {
            this.switchState(oldTerm);
        }
        return score;
    }

    public abstract double getScore();

    public abstract void proposeNewState(long var1);

    public void proposeNewState() {
        this.proposeNewState(this.rnd.nextLong());
    }

    public void exchange(int t1, int t2) {
        this.switchState(t1);
        this.switchState(t2);
    }

    public abstract void undoProposal();

    public abstract long getNeighborhoodSize();

    public void record() {
        for (int i = this.numInactiveTerms; i < this.numTerms; ++i) {
            int n = this.termPartition[i];
            this.termActivationCounts[n] = this.termActivationCounts[n] + 1;
        }
        ++this.numRecords;
    }

    public int[] getActiveTerms() {
        int[] list = new int[this.numTerms - this.numInactiveTerms];
        for (int i = this.numInactiveTerms; i < this.numTerms; ++i) {
            list[i - this.numInactiveTerms] = this.termPartition[i];
        }
        return list;
    }

    public static interface IGeneValueProvider {
        public double getGeneValue(int var1);

        public double getThreshold();

        public boolean smallerIsBetter();
    }
}

