/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import java.util.Random;
import org.monarchinitiative.phenol.analysis.mgsa.Gamma;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaScore;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;

public class FixedAlphaBetaScore
extends MgsaScore {
    private boolean integrateParams = false;
    private int proposalSwitch;
    private int proposalT1;
    private int proposalT2;
    protected double[] ALPHA = new double[]{1.0E-7, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95};
    private int alphaIdx = 0;
    private int oldAlphaIdx;
    protected int[] totalAlpha = new int[this.ALPHA.length];
    private boolean doAlphaMCMC = true;
    protected double[] BETA = this.ALPHA;
    private int betaIdx = 0;
    private int oldBetaIdx;
    protected int[] totalBeta = new int[this.BETA.length];
    private boolean doBetaMCMC = true;
    protected final int[] EXPECTED_NUMBER_OF_TERMS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private int expIdx = 0;
    private int oldExpIdx;
    protected int[] totalExp = new int[this.EXPECTED_NUMBER_OF_TERMS.length];
    private boolean doExpMCMC = true;
    protected double alpha = Double.NaN;
    protected double beta = Double.NaN;
    private final double[] lGamma = new double[20000];
    private int n00;
    private int n01;
    private int n10;
    private int n11;
    private long totalN00;
    private long totalN01;
    private long totalN10;
    private long totalN11;
    private long totalT;

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.doAlphaMCMC = Double.isNaN(alpha);
    }

    public void setBeta(double beta) {
        this.beta = beta;
        this.doBetaMCMC = Double.isNaN(beta);
    }

    @Override
    public void setExpectedNumberOfTerms(double terms) {
        super.setExpectedNumberOfTerms(terms);
        this.doExpMCMC = Double.isNaN(terms);
    }

    public void setMaxAlpha(double maxAlpha) {
        if (Double.isNaN(maxAlpha)) {
            maxAlpha = 1.0;
        }
        if (maxAlpha < 0.01) {
            maxAlpha = 0.01;
        }
        int span = maxAlpha > 0.99999999 ? 20 : 19;
        this.ALPHA = new double[20];
        this.totalAlpha = new int[20];
        this.ALPHA[0] = 1.0E-7;
        for (int i = 1; i < 20; ++i) {
            this.ALPHA[i] = (double)i * maxAlpha / (double)span;
        }
    }

    public void setMaxBeta(double maxBeta) {
        if (Double.isNaN(maxBeta)) {
            maxBeta = 1.0;
        }
        if (maxBeta < 0.01) {
            maxBeta = 0.01;
        }
        int span = maxBeta > 0.99999999 ? 20 : 19;
        this.BETA = new double[20];
        this.totalBeta = new int[20];
        this.BETA[0] = 1.0E-7;
        for (int i = 1; i < 20; ++i) {
            this.BETA[i] = (double)i * maxBeta / (double)span;
        }
    }

    public void setIntegrateParams(boolean integrateParams) {
        this.integrateParams = integrateParams;
    }

    public FixedAlphaBetaScore(Random rnd, int[][] termLinks, boolean[] observedGenes) {
        super(rnd, termLinks, observedGenes);
        this.setMaxAlpha(1.0);
        this.setMaxBeta(1.0);
        for (boolean observedGene : observedGenes) {
            if (!observedGene) continue;
            ++this.n10;
        }
        this.n00 = observedGenes.length - this.n10;
    }

    @Override
    public void hiddenGeneActivated(int gid) {
        if (this.observedGenes[gid]) {
            ++this.n11;
            --this.n10;
        } else {
            ++this.n01;
            --this.n00;
        }
    }

    @Override
    public void hiddenGeneDeactivated(int gid) {
        if (this.observedGenes[gid]) {
            --this.n11;
            ++this.n10;
        } else {
            --this.n01;
            ++this.n00;
        }
    }

    @Override
    public void proposeNewState(long rand) {
        long oldPossibilities = this.getNeighborhoodSize();
        this.proposalSwitch = -1;
        this.proposalT1 = -1;
        this.proposalT2 = -1;
        this.oldAlphaIdx = -1;
        this.oldBetaIdx = -1;
        this.oldExpIdx = -1;
        if (!this.doAlphaMCMC && !this.doBetaMCMC && !this.doExpMCMC || this.rnd.nextBoolean()) {
            long choose = Math.abs(rand) % oldPossibilities;
            if (choose < (long)this.numTerms) {
                this.proposalSwitch = (int)choose;
                this.switchState(this.proposalSwitch);
            } else {
                long base = choose - (long)this.numTerms;
                int activeTermPos = (int)(base / (long)this.numInactiveTerms);
                int inactiveTermPos = (int)(base % (long)this.numInactiveTerms);
                this.proposalT1 = this.termPartition[activeTermPos + this.numInactiveTerms];
                this.proposalT2 = this.termPartition[inactiveTermPos];
                this.exchange(this.proposalT1, this.proposalT2);
            }
        } else {
            int max = 0;
            if (this.doAlphaMCMC) {
                max += this.ALPHA.length;
            }
            if (this.doBetaMCMC) {
                max += this.BETA.length;
            }
            if (this.doExpMCMC) {
                max += this.EXPECTED_NUMBER_OF_TERMS.length;
            }
            int choose = Math.abs((int)rand) % max;
            if (this.doAlphaMCMC) {
                if (choose < this.ALPHA.length) {
                    this.oldAlphaIdx = this.alphaIdx;
                    this.alphaIdx = choose;
                    return;
                }
                choose -= this.ALPHA.length;
            }
            if (this.doBetaMCMC) {
                if (choose < this.BETA.length) {
                    this.oldBetaIdx = this.betaIdx;
                    this.betaIdx = choose;
                    return;
                }
                choose -= this.BETA.length;
            }
            if (!this.doExpMCMC) {
                throw new PhenolRuntimeException("MCMC requested proposal but no proposal is possible");
            }
            this.oldExpIdx = this.expIdx;
            this.expIdx = choose;
        }
    }

    public final double getAlpha() {
        double alpha = Double.isNaN(this.alpha) ? this.ALPHA[this.alphaIdx] : this.alpha;
        return alpha;
    }

    public final double getBeta() {
        double beta = Double.isNaN(this.beta) ? this.BETA[this.betaIdx] : this.beta;
        return beta;
    }

    public final double getP() {
        double p = Double.isNaN(this.p) ? (double)this.EXPECTED_NUMBER_OF_TERMS[this.expIdx] / (double)this.numTerms : this.p;
        return p;
    }

    private double logGamma(int a) {
        if (a == 1 || a == 2) {
            return 0.0;
        }
        if (a < this.lGamma.length) {
            double lg = this.lGamma[a];
            if (lg == 0.0) {
                this.lGamma[a] = lg = Gamma.lgamma(a);
            }
            return lg;
        }
        return Gamma.lgamma(a);
    }

    private double logBeta(int a, int b) {
        return this.logGamma(a) + this.logGamma(b) - this.logGamma(a + b);
    }

    @Override
    public double getScore() {
        double newScore2;
        if (!this.integrateParams) {
            double alpha = this.getAlpha();
            double beta = this.getBeta();
            double p = this.getP();
            newScore2 = Math.log(alpha) * (double)this.n10 + Math.log(1.0 - alpha) * (double)this.n00 + Math.log(1.0 - beta) * (double)this.n11 + Math.log(beta) * (double)this.n01;
            if (this.usePrior) {
                newScore2 += Math.log(p) * (double)(this.numTerms - this.numInactiveTerms) + Math.log(1.0 - p) * (double)this.numInactiveTerms;
            }
        } else {
            int alpha1 = 1;
            int alpha2 = 1;
            int beta1 = 1;
            int beta2 = 1;
            int p1 = 1;
            int p2 = 1;
            int m1 = this.numTerms - this.numInactiveTerms;
            int m0 = this.numInactiveTerms;
            double s1 = this.logBeta(alpha1 + this.n10, alpha2 + this.n00);
            double s2 = this.logBeta(beta1 + this.n01, beta2 + this.n11);
            double s3 = this.logBeta(p1 + m1, p2 + m0);
            newScore2 = s1 + s2 + s3;
        }
        return newScore2;
    }

    @Override
    public void undoProposal() {
        if (this.proposalSwitch != -1) {
            this.switchState(this.proposalSwitch);
        } else if (this.proposalT1 != -1) {
            this.exchange(this.proposalT2, this.proposalT1);
        } else if (this.oldAlphaIdx != -1) {
            this.alphaIdx = this.oldAlphaIdx;
        } else if (this.oldBetaIdx != -1) {
            this.betaIdx = this.oldBetaIdx;
        } else if (this.oldExpIdx != -1) {
            this.expIdx = this.oldExpIdx;
        } else {
            throw new PhenolRuntimeException("Wanted to undo a proposal that wasn't proposed");
        }
    }

    @Override
    public long getNeighborhoodSize() {
        return this.numTerms + (this.numTerms - this.numInactiveTerms) * this.numInactiveTerms;
    }

    @Override
    public void record() {
        super.record();
        this.totalN00 += (long)this.n00;
        this.totalN01 += (long)this.n01;
        this.totalN10 += (long)this.n10;
        this.totalN11 += (long)this.n11;
        int n = this.alphaIdx;
        this.totalAlpha[n] = this.totalAlpha[n] + 1;
        int n2 = this.betaIdx;
        this.totalBeta[n2] = this.totalBeta[n2] + 1;
        int n3 = this.expIdx;
        this.totalExp[n3] = this.totalExp[n3] + 1;
        this.totalT += (long)(this.numTerms - this.numInactiveTerms);
    }

    public double getAvgN00() {
        return (double)this.totalN00 / (double)this.numRecords;
    }

    public double getAvgN01() {
        return (double)this.totalN01 / (double)this.numRecords;
    }

    public double getAvgN10() {
        return (double)this.totalN10 / (double)this.numRecords;
    }

    public double getAvgN11() {
        return (double)this.totalN11 / (double)this.numRecords;
    }

    public double getAvgT() {
        return (double)this.totalT / (double)this.numRecords;
    }

    public double[] getAlphaValues() {
        return this.ALPHA;
    }

    private double[] getDistribution(int[] counts) {
        double[] dist = new double[counts.length];
        int total = 0;
        for (int a : counts) {
            total += a;
        }
        for (int i = 0; i < counts.length; ++i) {
            dist[i] = (double)counts[i] / (double)total;
        }
        return dist;
    }

    public double[] getAlphaDistribution() {
        return this.getDistribution(this.totalAlpha);
    }

    public double[] getBetaValues() {
        return this.BETA;
    }

    public double[] getBetaDistribution() {
        return this.getDistribution(this.totalBeta);
    }
}

