/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import org.monarchinitiative.phenol.analysis.mgsa.MgsaParam;

class DoubleParam
extends MgsaParam {
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double val;

    public DoubleParam(MgsaParam.Type type, double val) {
        super(type);
        this.val = val;
    }

    public DoubleParam(DoubleParam p) {
        super(p);
        this.val = p.val;
    }

    public DoubleParam(MgsaParam.Type type) {
        super(type);
        if (type == MgsaParam.Type.FIXED) {
            throw new IllegalArgumentException("Parameter could not be instanciated of type Fixed.");
        }
    }

    double getValue() {
        return this.val;
    }

    void setValue(double newVal) {
        this.val = newVal;
        this.setType(MgsaParam.Type.FIXED);
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean hasMin() {
        return !Double.isNaN(this.min);
    }

    public double getMax() {
        return this.max;
    }

    public boolean hasMax() {
        return !Double.isNaN(this.max);
    }

    public String toString() {
        if (this.isFixed()) {
            return Double.toString(this.val);
        }
        return this.getType().toString();
    }
}

