/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.AssociationContainer;
import org.monarchinitiative.phenol.analysis.DirectAndIndirectTermAnnotations;
import org.monarchinitiative.phenol.analysis.GeneAnnotations;
import org.monarchinitiative.phenol.analysis.ItemAnnotations;
import org.monarchinitiative.phenol.analysis.util.Util;
import org.monarchinitiative.phenol.annotations.io.go.GoGeneAnnotationParser;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermAssociationContainer
implements AssociationContainer<TermId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TermAssociationContainer.class);
    private final List<? extends TermAnnotation> rawAssociations;
    private final Map<TermId, GeneAnnotations> gene2associationMap;
    private final int annotatingTermCount;
    private final MinimalOntology ontology;

    private TermAssociationContainer(MinimalOntology ontology, List<? extends TermAnnotation> rawAssociations, Map<TermId, GeneAnnotations> gene2associationMap, int annotatingTermCount) {
        this.ontology = ontology;
        this.rawAssociations = rawAssociations;
        this.gene2associationMap = gene2associationMap;
        this.annotatingTermCount = annotatingTermCount;
    }

    @Override
    public Map<TermId, List<TermId>> getOntologyTermToDomainItemsMap() {
        HashMap mp = new HashMap();
        for (Map.Entry<TermId, GeneAnnotations> entry : this.gene2associationMap.entrySet()) {
            TermId gene = entry.getKey();
            for (TermId ontologyTermId : entry.getValue().getAnnotatingTermIds()) {
                mp.putIfAbsent(ontologyTermId, new ArrayList());
                ((List)mp.get(ontologyTermId)).add(gene);
            }
        }
        return Map.copyOf(mp);
    }

    @Override
    public int getAnnotatingTermCount() {
        return this.annotatingTermCount;
    }

    @Override
    public int getTotalAnnotationCount() {
        return this.rawAssociations.size();
    }

    public List<? extends TermAnnotation> getRawAssociations() {
        return this.rawAssociations;
    }

    public GeneAnnotations get(TermId dbObjectId) throws PhenolException {
        if (!this.gene2associationMap.containsKey(dbObjectId)) {
            throw new PhenolException("Could not find annotations for " + dbObjectId.getValue());
        }
        return this.gene2associationMap.get(dbObjectId);
    }

    @Override
    public Set<TermId> getAllAnnotatedGenes() {
        return this.gene2associationMap.keySet();
    }

    @Override
    public Set<TermId> getDomainItemsAnnotatedByOntologyTerm(TermId tid) {
        return Util.getDomainItemsAnnotatedByOntologyTerm(tid, this.ontology, this.gene2associationMap);
    }

    public int getTotalNumberOfAnnotatedItems() {
        return this.gene2associationMap.size();
    }

    @Override
    public Map<TermId, DirectAndIndirectTermAnnotations> getAssociationMap(Set<TermId> annotatedItemTermIds) {
        HashMap<TermId, Set> directAnnotationMap = new HashMap<TermId, Set>();
        int not_found = 0;
        for (TermId domainTermId : annotatedItemTermIds) {
            if (!this.gene2associationMap.containsKey(domainTermId)) {
                LOGGER.error("Could not find annotations for  {}", (Object)domainTermId.getValue());
                continue;
            }
            GeneAnnotations assocs = this.gene2associationMap.get(domainTermId);
            for (TermAnnotation termAnnotation : assocs.getAnnotations()) {
                TermId ontologyTermId = termAnnotation.id();
                Optional<TermId> primary = this.ontology.termForTermId(ontologyTermId).map(Identified::id);
                if (primary.isEmpty()) {
                    ++not_found;
                    LOGGER.warn("Unable to retrieve ontology term {} (omitted).", (Object)ontologyTermId.getValue());
                    continue;
                }
                ontologyTermId = primary.get();
                directAnnotationMap.computeIfAbsent(domainTermId, k -> new HashSet()).add(ontologyTermId);
            }
        }
        if (not_found > 0) {
            LOGGER.warn("Cound not find annotations for {} ontology term ids (are versions in synch?)", (Object)not_found);
        }
        HashMap<TermId, DirectAndIndirectTermAnnotations> annotationMap = new HashMap<TermId, DirectAndIndirectTermAnnotations>();
        for (Map.Entry entry : directAnnotationMap.entrySet()) {
            TermId domainItemTermId = (TermId)entry.getKey();
            for (TermId ontologyId : (Set)entry.getValue()) {
                annotationMap.putIfAbsent(ontologyId, new DirectAndIndirectTermAnnotations(ontologyId));
                ((DirectAndIndirectTermAnnotations)annotationMap.get(ontologyId)).addDirectAnnotatedItem(domainItemTermId);
                for (TermId ancestor : this.ontology.graph().getAncestors((Object)ontologyId, false)) {
                    annotationMap.putIfAbsent(ancestor, new DirectAndIndirectTermAnnotations(ancestor));
                    ((DirectAndIndirectTermAnnotations)annotationMap.get(ancestor)).addIndirectAnnotatedItem(domainItemTermId);
                }
            }
        }
        return Map.copyOf(annotationMap);
    }

    public static TermAssociationContainer fromGoTermAnnotations(List<? extends TermAnnotation> goAnnots, MinimalOntology ontology) {
        HashMap<TermId, Set> domainItemToAnnotationMap = new HashMap<TermId, Set>();
        for (TermAnnotation termAnnotation : goAnnots) {
            TermId itemId = termAnnotation.getItemId();
            domainItemToAnnotationMap.computeIfAbsent(itemId, k -> new HashSet()).add(termAnnotation);
        }
        HashMap<TermId, GeneAnnotations> gene2associationMap = new HashMap<TermId, GeneAnnotations>();
        domainItemToAnnotationMap.forEach((k, v) -> gene2associationMap.put((TermId)k, GeneAnnotations.of(k, List.copyOf(v))));
        long l = gene2associationMap.values().stream().map(ItemAnnotations::getAnnotatingTermIds).distinct().count();
        return new TermAssociationContainer(ontology, goAnnots, gene2associationMap, Math.toIntExact(l));
    }

    public static TermAssociationContainer loadGoGafAssociationContainer(File goGafFile, Ontology ontology) {
        List goAnnots = GoGeneAnnotationParser.loadAnnotations((Path)goGafFile.toPath());
        return TermAssociationContainer.fromGoTermAnnotations(goAnnots, (MinimalOntology)ontology);
    }
}

