/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.DirectAndIndirectTermAnnotations;
import org.monarchinitiative.phenol.analysis.ItemSet;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class StudySet
implements ItemSet<TermId> {
    private final Map<TermId, DirectAndIndirectTermAnnotations> annotationMap;
    private final String name;
    private final Set<String> unmappedGeneSymbols;
    private final int domainItemCount;

    public StudySet(String name, Map<TermId, DirectAndIndirectTermAnnotations> associationContainer) {
        this(name, associationContainer, new HashSet<String>());
    }

    public StudySet(String name, Map<TermId, DirectAndIndirectTermAnnotations> associationContainer, Set<String> unmappedGenes) {
        this.name = name;
        this.annotationMap = associationContainer;
        this.unmappedGeneSymbols = unmappedGenes;
        this.domainItemCount = this.getGeneSet().size();
    }

    @Override
    public Map<TermId, DirectAndIndirectTermAnnotations> getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public Set<TermId> getGeneSet() {
        HashSet<TermId> domainItemIdSet = new HashSet<TermId>();
        for (DirectAndIndirectTermAnnotations dai : this.annotationMap.values()) {
            domainItemIdSet.addAll(dai.getTotalAnnotatedDomainItemSet());
        }
        return domainItemIdSet;
    }

    public Set<TermId> getOntologyTermIds() {
        return this.annotationMap.keySet();
    }

    public DirectAndIndirectTermAnnotations getAnnotatedGenes(TermId goId) {
        return this.annotationMap.get(goId);
    }

    @Override
    public int getDirectAnnotationCount(TermId tid) {
        if (this.annotationMap.containsKey(tid)) {
            return this.annotationMap.get(tid).directAnnotatedCount();
        }
        return 0;
    }

    public int getTotalAnnotationCount(TermId tid) {
        if (this.annotationMap.containsKey(tid)) {
            return this.annotationMap.get(tid).totalAnnotatedCount();
        }
        return 0;
    }

    public int getAnnotatedItemCount() {
        return this.domainItemCount;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (n=" + this.getAnnotatedItemCount() + ")";
    }

    public boolean contains(TermId geneName) {
        return this.annotationMap.containsKey(geneName);
    }

    public static StudySet populationSet(Map<TermId, DirectAndIndirectTermAnnotations> associationContainer) {
        return new StudySet("population", associationContainer);
    }
}

