/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis;

import java.util.List;
import java.util.Objects;
import org.monarchinitiative.phenol.analysis.ItemAnnotations;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GeneAnnotations
implements ItemAnnotations<TermId> {
    private final TermId annotatedGene;
    private final List<TermAnnotation> annotations;

    public static GeneAnnotations of(TermId annotatedGene, List<TermAnnotation> annotations) {
        return new GeneAnnotations(annotatedGene, annotations);
    }

    private GeneAnnotations(TermId annotatedGene, List<TermAnnotation> annotations) {
        this.annotatedGene = Objects.requireNonNull(annotatedGene, "Annotated gene term ID must not be null");
        this.annotations = Objects.requireNonNull(annotations, "Annotations must not be null");
    }

    @Override
    public TermId annotatedItem() {
        return this.annotatedGene;
    }

    @Override
    public List<TermAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneAnnotations that = (GeneAnnotations)o;
        return Objects.equals(this.annotatedGene, that.annotatedGene) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedGene, this.annotations);
    }

    public String toString() {
        return "GeneAnnotations{annotatedGene=" + String.valueOf(this.annotatedGene) + ", annotations=" + String.valueOf(this.annotations) + "}";
    }
}

