/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.validate;

import java.util.Collection;
import java.util.regex.Pattern;
import org.moera.lib.node.types.EmojiList;
import org.moera.lib.node.types.body.Body;
import org.moera.lib.node.types.validate.ValidationFailure;

public class ValidationUtil {
    private static final Pattern DOMAIN_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9-]*[a-z0-9](\\.[a-z][a-z0-9-]*[a-z0-9])*$", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w-.]+@([\\w-]+\\.)+[\\w-]{2,}$", 2);

    public static void assertion(boolean condition, String errorCode) {
        if (!condition) {
            throw new ValidationFailure(errorCode);
        }
    }

    public static void notNull(Object value, String errorCode) {
        ValidationUtil.assertion(value != null, errorCode);
    }

    public static void notBlank(String value, String errorCode) {
        ValidationUtil.assertion(value != null && !value.isEmpty(), errorCode);
    }

    public static void maxSize(String value, int maxSize, String errorCode) {
        ValidationUtil.assertion(value == null || value.length() <= maxSize, errorCode);
    }

    public static void maxSize(Body value, int maxSize, String errorCode) {
        ValidationUtil.maxSize(value != null ? value.getEncoded() : null, maxSize, errorCode);
    }

    public static void minValue(Integer value, int min, String errorCode) {
        ValidationUtil.assertion(value == null || value >= min, errorCode);
    }

    public static void minValue(Long value, long min, String errorCode) {
        ValidationUtil.assertion(value == null || value >= min, errorCode);
    }

    public static void minValue(Float value, float min, String errorCode) {
        ValidationUtil.assertion(value == null || value.floatValue() >= min, errorCode);
    }

    public static void maxValue(Integer value, int max, String errorCode) {
        ValidationUtil.assertion(value == null || value <= max, errorCode);
    }

    public static void maxValue(Long value, long max, String errorCode) {
        ValidationUtil.assertion(value == null || value <= max, errorCode);
    }

    public static void maxValue(Float value, float max, String errorCode) {
        ValidationUtil.assertion(value == null || value.floatValue() <= max, errorCode);
    }

    public static void minItems(Object[] array, int minItems, String errorCode) {
        ValidationUtil.assertion(array == null || array.length >= minItems, errorCode);
    }

    public static void minItems(Collection<?> collection, int minItems, String errorCode) {
        ValidationUtil.assertion(collection == null || collection.size() >= minItems, errorCode);
    }

    public static void maxItems(Object[] array, int maxItems, String errorCode) {
        ValidationUtil.assertion(array == null || array.length <= maxItems, errorCode);
    }

    public static void maxItems(Collection<?> collection, int maxItems, String errorCode) {
        ValidationUtil.assertion(collection == null || collection.size() <= maxItems, errorCode);
    }

    public static void domainName(String value, String errorCode) {
        ValidationUtil.assertion(value == null || value.isEmpty() || DOMAIN_NAME_PATTERN.matcher(value).matches(), errorCode);
    }

    public static void email(String value, String errorCode) {
        ValidationUtil.assertion(value == null || value.isEmpty() || EMAIL_PATTERN.matcher(value).matches(), errorCode);
    }

    public static void emojiList(String value, String errorCode) {
        ValidationUtil.assertion(value == null || value.isEmpty() || EmojiList.isValid(value), errorCode);
    }
}

