/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.principal;

import org.moera.lib.node.types.principal.InvalidPrincipalExpression;
import org.moera.lib.node.types.principal.Principal;
import org.moera.lib.node.types.principal.PrincipalFilter;

public final class PrincipalExpression
implements PrincipalFilter {
    private final Principal principal;
    private final boolean inverse;
    private final Operation operation;
    private final PrincipalExpression left;
    private final PrincipalExpression right;

    private PrincipalExpression(Principal principal, boolean inverse) {
        this.principal = principal;
        this.inverse = inverse;
        this.operation = null;
        this.left = null;
        this.right = null;
    }

    private PrincipalExpression(Operation operation, PrincipalExpression left, PrincipalExpression right) {
        this.principal = null;
        this.inverse = false;
        this.operation = operation;
        this.left = left;
        this.right = right;
    }

    private PrincipalExpression(Principal principal, boolean inverse, Operation operation, PrincipalExpression left, PrincipalExpression right) {
        this.principal = principal;
        this.inverse = inverse;
        this.operation = operation;
        this.left = left;
        this.right = right;
    }

    @Override
    public PrincipalExpression a() {
        return this;
    }

    public PrincipalExpression not() {
        return PrincipalExpression.not(this);
    }

    public static PrincipalExpression by(Principal principal) {
        return new PrincipalExpression(principal, false);
    }

    public static PrincipalExpression byNot(Principal principal) {
        return new PrincipalExpression(principal, true);
    }

    public static PrincipalExpression not(PrincipalExpression expression) {
        return new PrincipalExpression(expression.principal, !expression.inverse, expression.operation, expression.left, expression.right);
    }

    public PrincipalExpression or(PrincipalExpression expression) {
        return new PrincipalExpression(Operation.OR, this, expression);
    }

    public PrincipalExpression or(Principal principal) {
        return new PrincipalExpression(Operation.OR, this, PrincipalExpression.by(principal));
    }

    public PrincipalExpression orNot(Principal principal) {
        return new PrincipalExpression(Operation.OR, this, PrincipalExpression.byNot(principal));
    }

    public PrincipalExpression and(PrincipalExpression expression) {
        return new PrincipalExpression(Operation.AND, this, expression);
    }

    public PrincipalExpression and(Principal principal) {
        return new PrincipalExpression(Operation.AND, this, PrincipalExpression.by(principal));
    }

    public PrincipalExpression andNot(Principal principal) {
        return new PrincipalExpression(Operation.AND, this, PrincipalExpression.byNot(principal));
    }

    @Override
    public boolean includes(boolean admin, String nodeName, boolean subscribed, String[] friendGroups) {
        if (this.principal != null) {
            return this.inverse != this.principal.includes(admin, nodeName, subscribed, friendGroups);
        }
        if (this.operation == Operation.OR) {
            if (this.left == null) {
                throw new InvalidPrincipalExpression("Left operand not set");
            }
            if (this.right == null) {
                throw new InvalidPrincipalExpression("Right operand not set");
            }
            return this.inverse != (this.left.includes(admin, nodeName, subscribed, friendGroups) || this.right.includes(admin, nodeName, subscribed, friendGroups));
        }
        if (this.operation == Operation.AND) {
            if (this.left == null) {
                throw new InvalidPrincipalExpression("Left operand not set");
            }
            if (this.right == null) {
                throw new InvalidPrincipalExpression("Right operand not set");
            }
            return this.inverse != (this.left.includes(admin, nodeName, subscribed, friendGroups) && this.right.includes(admin, nodeName, subscribed, friendGroups));
        }
        throw new InvalidPrincipalExpression("Operation not set");
    }

    public String toString() {
        if (this.principal != null) {
            return (this.inverse ? "not " : "") + String.valueOf(this.principal);
        }
        if (this.operation == null) {
            throw new InvalidPrincipalExpression("Operation not set");
        }
        if (this.left == null) {
            throw new InvalidPrincipalExpression("Left operand not set");
        }
        if (this.right == null) {
            throw new InvalidPrincipalExpression("Right operand not set");
        }
        return this.inverse ? "not ((%s) %s (%s))".formatted(this.left, this.operation.name().toLowerCase(), this.right) : "(%s) %s (%s)".formatted(this.left, this.operation.name().toLowerCase(), this.right);
    }

    static enum Operation {
        OR,
        AND;

    }
}

