/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.StoryType;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StoryAddedNotification
extends SubscriberNotification {
    private String storyId;
    private String feedName;
    private StoryType storyType;
    private String postingId;

    public StoryAddedNotification() {
        super(NotificationType.STORY_ADDED);
    }

    public String getStoryId() {
        return this.storyId;
    }

    public void setStoryId(String storyId) {
        this.storyId = storyId;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public StoryType getStoryType() {
        return this.storyType;
    }

    public void setStoryType(StoryType storyType) {
        this.storyType = storyType;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.storyId, 40, "story.story-id.wrong-size");
        ValidationUtil.maxSize(this.feedName, 63, "story.feed-name.wrong-size");
        ValidationUtil.maxSize(this.postingId, 40, "story.posting-id.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("storyId", LogUtil.format(this.storyId)));
        parameters.add(LogPair.of("feedName", LogUtil.format(this.feedName)));
        parameters.add(LogPair.of("storyType", LogUtil.format(this.storyType.toString())));
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
    }
}

