/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.SheriffMark;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MentionCommentAddedNotification
extends Notification {
    private String postingId;
    private String commentId;
    private String postingOwnerName;
    private String postingOwnerFullName;
    private String postingOwnerGender;
    private AvatarImage postingOwnerAvatar;
    private String postingHeading;
    private List<String> postingSheriffs;
    private List<SheriffMark> postingSheriffMarks;
    private String commentOwnerName;
    private String commentOwnerFullName;
    private String commentOwnerGender;
    private AvatarImage commentOwnerAvatar;
    private String commentHeading;
    private List<SheriffMark> commentSheriffMarks;

    public MentionCommentAddedNotification() {
        super(NotificationType.MENTION_COMMENT_ADDED);
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getPostingOwnerName() {
        return this.postingOwnerName;
    }

    public void setPostingOwnerName(String postingOwnerName) {
        this.postingOwnerName = postingOwnerName;
    }

    public String getPostingOwnerFullName() {
        return this.postingOwnerFullName;
    }

    public void setPostingOwnerFullName(String postingOwnerFullName) {
        this.postingOwnerFullName = postingOwnerFullName;
    }

    public String getPostingOwnerGender() {
        return this.postingOwnerGender;
    }

    public void setPostingOwnerGender(String postingOwnerGender) {
        this.postingOwnerGender = postingOwnerGender;
    }

    public AvatarImage getPostingOwnerAvatar() {
        return this.postingOwnerAvatar;
    }

    public void setPostingOwnerAvatar(AvatarImage postingOwnerAvatar) {
        this.postingOwnerAvatar = postingOwnerAvatar;
    }

    public String getPostingHeading() {
        return this.postingHeading;
    }

    public void setPostingHeading(String postingHeading) {
        this.postingHeading = postingHeading;
    }

    public List<String> getPostingSheriffs() {
        return this.postingSheriffs;
    }

    public void setPostingSheriffs(List<String> postingSheriffs) {
        this.postingSheriffs = postingSheriffs;
    }

    public List<SheriffMark> getPostingSheriffMarks() {
        return this.postingSheriffMarks;
    }

    public void setPostingSheriffMarks(List<SheriffMark> postingSheriffMarks) {
        this.postingSheriffMarks = postingSheriffMarks;
    }

    public String getCommentOwnerName() {
        return this.commentOwnerName;
    }

    public void setCommentOwnerName(String commentOwnerName) {
        this.commentOwnerName = commentOwnerName;
    }

    public String getCommentOwnerFullName() {
        return this.commentOwnerFullName;
    }

    public void setCommentOwnerFullName(String commentOwnerFullName) {
        this.commentOwnerFullName = commentOwnerFullName;
    }

    public String getCommentOwnerGender() {
        return this.commentOwnerGender;
    }

    public void setCommentOwnerGender(String commentOwnerGender) {
        this.commentOwnerGender = commentOwnerGender;
    }

    public AvatarImage getCommentOwnerAvatar() {
        return this.commentOwnerAvatar;
    }

    public void setCommentOwnerAvatar(AvatarImage commentOwnerAvatar) {
        this.commentOwnerAvatar = commentOwnerAvatar;
    }

    public String getCommentHeading() {
        return this.commentHeading;
    }

    public void setCommentHeading(String commentHeading) {
        this.commentHeading = commentHeading;
    }

    public List<SheriffMark> getCommentSheriffMarks() {
        return this.commentSheriffMarks;
    }

    public void setCommentSheriffMarks(List<SheriffMark> commentSheriffMarks) {
        this.commentSheriffMarks = commentSheriffMarks;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "mention.posting-id.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "mention.comment-id.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerName, 63, "mention.posting-owner-name.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerFullName, 96, "mention.posting-owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerGender, 31, "mention.posting-owner-gender.wrong-size");
        ValidationUtil.maxSize(this.postingHeading, 255, "mention.posting-heading.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerName, 63, "mention.comment-owner-name.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerFullName, 96, "mention.comment-owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerGender, 31, "mention.comment-owner-gender.wrong-size");
        ValidationUtil.maxSize(this.commentHeading, 255, "mention.comment-heading.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("commentId", LogUtil.format(this.commentId)));
        parameters.add(LogPair.of("postingOwnerName", LogUtil.format(this.postingOwnerName)));
        parameters.add(LogPair.of("postingHeading", LogUtil.format(this.postingHeading)));
        parameters.add(LogPair.of("commentOwnerName", LogUtil.format(this.commentOwnerName)));
        parameters.add(LogPair.of("commentHeading", LogUtil.format(this.commentHeading)));
    }
}

