/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum VerificationStatus {
    RUNNING,
    CORRECT,
    INCORRECT,
    ERROR;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(VerificationStatus type) {
        return type != null ? type.getValue() : null;
    }

    public static VerificationStatus forValue(String value) {
        try {
            return VerificationStatus.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VerificationStatus parse(String value) {
        return VerificationStatus.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

