/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.SubscriberOperations;
import org.moera.lib.node.types.SubscriptionType;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SubscriberDescription
extends Structure
implements Cloneable {
    private SubscriptionType type;
    private String feedName;
    private String postingId;
    private Long lastUpdatedAt;
    private SubscriberOperations operations;

    public SubscriptionType getType() {
        return this.type;
    }

    public void setType(SubscriptionType type) {
        this.type = type;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public Long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public void setLastUpdatedAt(Long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public SubscriberOperations getOperations() {
        return this.operations;
    }

    public void setOperations(SubscriberOperations operations) {
        this.operations = operations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.type, "subscriber.type.missing");
        ValidationUtil.maxSize(this.feedName, 63, "subscriber.feed-name.wrong-size");
    }

    public SubscriberDescription clone() {
        try {
            return (SubscriberDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

