/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum StoryType {
    POSTING_ADDED,
    REACTION_ADDED_POSITIVE,
    REACTION_ADDED_NEGATIVE,
    MENTION_POSTING,
    SUBSCRIBER_ADDED,
    SUBSCRIBER_DELETED,
    COMMENT_ADDED,
    MENTION_COMMENT,
    REPLY_COMMENT,
    COMMENT_REACTION_ADDED_POSITIVE,
    COMMENT_REACTION_ADDED_NEGATIVE,
    REMOTE_COMMENT_ADDED,
    COMMENT_POST_TASK_FAILED,
    COMMENT_UPDATE_TASK_FAILED,
    POSTING_UPDATED,
    POSTING_POST_TASK_FAILED,
    POSTING_UPDATE_TASK_FAILED,
    POSTING_MEDIA_REACTION_ADDED_POSITIVE,
    POSTING_MEDIA_REACTION_ADDED_NEGATIVE,
    COMMENT_MEDIA_REACTION_ADDED_POSITIVE,
    COMMENT_MEDIA_REACTION_ADDED_NEGATIVE,
    POSTING_MEDIA_REACTION_FAILED,
    COMMENT_MEDIA_REACTION_FAILED,
    POSTING_SUBSCRIBE_TASK_FAILED,
    POSTING_REACTION_TASK_FAILED,
    COMMENT_REACTION_TASK_FAILED,
    FRIEND_ADDED,
    FRIEND_DELETED,
    FRIEND_GROUP_DELETED,
    ASKED_TO_SUBSCRIBE,
    ASKED_TO_FRIEND,
    BLOCKED_USER,
    UNBLOCKED_USER,
    BLOCKED_USER_IN_POSTING,
    UNBLOCKED_USER_IN_POSTING,
    SHERIFF_MARKED,
    SHERIFF_UNMARKED,
    SHERIFF_COMPLAINT_ADDED,
    SHERIFF_COMPLAINT_DECIDED,
    DEFROSTING,
    SEARCH_REPORT,
    REMINDER_FULL_NAME,
    REMINDER_AVATAR,
    REMINDER_EMAIL,
    REMINDER_SHERIFF_ALLOW;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(StoryType type) {
        return type != null ? type.getValue() : null;
    }

    public static StoryType forValue(String value) {
        try {
            return StoryType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static StoryType parse(String value) {
        return StoryType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

