/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.SheriffOrderReason;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SheriffComplaintText
extends Structure
implements Cloneable {
    private String ownerFullName;
    private String ownerGender;
    private String nodeName;
    private String fullName;
    private String feedName;
    private String postingId;
    private String postingOwnerName;
    private String postingOwnerFullName;
    private String postingOwnerGender;
    private String postingHeading;
    private String commentId;
    private String commentOwnerName;
    private String commentOwnerFullName;
    private String commentOwnerGender;
    private String commentHeading;
    private SheriffOrderReason reasonCode;
    private String reasonDetails;
    private Boolean anonymous;

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public String getOwnerGender() {
        return this.ownerGender;
    }

    public void setOwnerGender(String ownerGender) {
        this.ownerGender = ownerGender;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getPostingOwnerName() {
        return this.postingOwnerName;
    }

    public void setPostingOwnerName(String postingOwnerName) {
        this.postingOwnerName = postingOwnerName;
    }

    public String getPostingOwnerFullName() {
        return this.postingOwnerFullName;
    }

    public void setPostingOwnerFullName(String postingOwnerFullName) {
        this.postingOwnerFullName = postingOwnerFullName;
    }

    public String getPostingOwnerGender() {
        return this.postingOwnerGender;
    }

    public void setPostingOwnerGender(String postingOwnerGender) {
        this.postingOwnerGender = postingOwnerGender;
    }

    public String getPostingHeading() {
        return this.postingHeading;
    }

    public void setPostingHeading(String postingHeading) {
        this.postingHeading = postingHeading;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getCommentOwnerName() {
        return this.commentOwnerName;
    }

    public void setCommentOwnerName(String commentOwnerName) {
        this.commentOwnerName = commentOwnerName;
    }

    public String getCommentOwnerFullName() {
        return this.commentOwnerFullName;
    }

    public void setCommentOwnerFullName(String commentOwnerFullName) {
        this.commentOwnerFullName = commentOwnerFullName;
    }

    public String getCommentOwnerGender() {
        return this.commentOwnerGender;
    }

    public void setCommentOwnerGender(String commentOwnerGender) {
        this.commentOwnerGender = commentOwnerGender;
    }

    public String getCommentHeading() {
        return this.commentHeading;
    }

    public void setCommentHeading(String commentHeading) {
        this.commentHeading = commentHeading;
    }

    public SheriffOrderReason getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(SheriffOrderReason reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getReasonDetails() {
        return this.reasonDetails;
    }

    public void setReasonDetails(String reasonDetails) {
        this.reasonDetails = reasonDetails;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.ownerFullName, 96, "sheriff-complaint.owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.ownerGender, 31, "sheriff-complaint.owner-gender.wrong-size");
        ValidationUtil.notBlank(this.nodeName, "sheriff-complaint.node-name.blank");
        ValidationUtil.maxSize(this.nodeName, 63, "sheriff-complaint.node-name.wrong-size");
        ValidationUtil.maxSize(this.fullName, 96, "sheriff-complaint.full-name.wrong-size");
        ValidationUtil.notBlank(this.feedName, "sheriff-complaint.feed-name.blank");
        ValidationUtil.maxSize(this.feedName, 63, "sheriff-complaint.feed-name.wrong-size");
        ValidationUtil.maxSize(this.postingId, 40, "sheriff-complaint.posting-id.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerName, 63, "sheriff-complaint.posting-owner-name.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerFullName, 96, "sheriff-complaint.posting-owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.postingOwnerGender, 31, "sheriff-complaint.posting-owner-gender.wrong-size");
        ValidationUtil.maxSize(this.postingHeading, 255, "sheriff-complaint.posting-heading.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "sheriff-complaint.comment-id.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerName, 63, "sheriff-complaint.comment-owner-name.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerFullName, 96, "sheriff-complaint.comment-owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.commentOwnerGender, 31, "sheriff-complaint.comment-owner-gender.wrong-size");
        ValidationUtil.maxSize(this.commentHeading, 255, "sheriff-complaint.comment-heading.wrong-size");
        ValidationUtil.maxSize(this.reasonDetails, 4096, "sheriff-complaint.reason-details.wrong-size");
    }

    public SheriffComplaintText clone() {
        try {
            return (SheriffComplaintText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

