/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SearchEngine {
    GOOGLE;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SearchEngine type) {
        return type != null ? type.getValue() : null;
    }

    public static SearchEngine forValue(String value) {
        try {
            return SearchEngine.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SearchEngine parse(String value) {
        return SearchEngine.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

