/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SettingDescriptor;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PluginDescription
extends Structure
implements Cloneable {
    private String name;
    private String title;
    private String description;
    private String location;
    private List<String> acceptedEvents;
    private List<SettingDescriptor> options;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getAcceptedEvents() {
        return this.acceptedEvents;
    }

    public void setAcceptedEvents(List<String> acceptedEvents) {
        this.acceptedEvents = acceptedEvents;
    }

    public List<SettingDescriptor> getOptions() {
        return this.options;
    }

    public void setOptions(List<SettingDescriptor> options) {
        this.options = options;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notBlank(this.name, "plugin.name.blank");
        ValidationUtil.maxSize(this.name, 48, "plugin.name.wrong-size");
        ValidationUtil.maxSize(this.title, 80, "plugin.title.wrong-size");
        ValidationUtil.maxSize(this.description, 256, "plugin.description.wrong-size");
    }

    public PluginDescription clone() {
        try {
            return (PluginDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

