/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.BlockedOperation;
import org.moera.lib.node.types.SourceFormat;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BlockedUserAttributes
extends Structure
implements Cloneable {
    private BlockedOperation blockedOperation;
    private String nodeName;
    private String entryId;
    private String entryNodeName;
    private String entryPostingId;
    private Long deadline;
    private String reasonSrc;
    private SourceFormat reasonSrcFormat;

    public BlockedOperation getBlockedOperation() {
        return this.blockedOperation;
    }

    public void setBlockedOperation(BlockedOperation blockedOperation) {
        this.blockedOperation = blockedOperation;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public String getEntryNodeName() {
        return this.entryNodeName;
    }

    public void setEntryNodeName(String entryNodeName) {
        this.entryNodeName = entryNodeName;
    }

    public String getEntryPostingId() {
        return this.entryPostingId;
    }

    public void setEntryPostingId(String entryPostingId) {
        this.entryPostingId = entryPostingId;
    }

    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public String getReasonSrc() {
        return this.reasonSrc;
    }

    public void setReasonSrc(String reasonSrc) {
        this.reasonSrc = reasonSrc;
    }

    public SourceFormat getReasonSrcFormat() {
        return this.reasonSrcFormat;
    }

    public void setReasonSrcFormat(SourceFormat reasonSrcFormat) {
        this.reasonSrcFormat = reasonSrcFormat;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.blockedOperation, "blocked-user.blocked-operation.missing");
        ValidationUtil.notBlank(this.nodeName, "blocked-user.node-name.blank");
        ValidationUtil.maxSize(this.reasonSrc, 4096, "blocked-user.reason-src.wrong-size");
    }

    public BlockedUserAttributes clone() {
        try {
            return (BlockedUserAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

