/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.naming;

import org.moera.lib.naming.NodeNameParsingException;

public class NodeName {
    private String name;
    private int generation;

    public static NodeName parse(String nodeName) {
        NodeName result = new NodeName();
        if (nodeName == null || nodeName.isEmpty()) {
            return result;
        }
        String[] parts = nodeName.split("_");
        result.setName(parts[0]);
        if (parts.length > 1) {
            try {
                result.setGeneration(Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                throw new NodeNameParsingException("Invalid value for generation: " + parts[1]);
            }
        }
        return result;
    }

    public static String shorten(String nodeName) {
        if (nodeName == null || nodeName.isEmpty()) {
            return nodeName;
        }
        return NodeName.parse(nodeName).toShortString();
    }

    public static String expand(String nodeName) {
        if (nodeName == null || nodeName.isEmpty()) {
            return nodeName;
        }
        return NodeName.parse(nodeName).toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public String toString() {
        return NodeName.toString(this.name, this.generation);
    }

    public String toShortString() {
        return this.generation != 0 ? this.toString() : this.name;
    }

    public static String toString(String name, int generation) {
        return name != null ? "%s_%d".formatted(name, generation) : null;
    }
}

