/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.moera.lib.crypto.CryptoException;
import org.moera.lib.crypto.FieldWithSchema;
import org.moera.lib.crypto.Fingerprint;
import org.moera.lib.crypto.FingerprintException;
import org.moera.lib.util.Util;

public class FingerprintReader
implements AutoCloseable {
    private final ByteArrayInputStream in;

    FingerprintReader(byte[] input) {
        this.in = new ByteArrayInputStream(input);
    }

    private Boolean readBoolean() {
        int value = this.in.read();
        if (value == 255) {
            return null;
        }
        return value != 0;
    }

    private Long readNumber() {
        int len;
        int lower = this.in.read();
        switch (lower) {
            case 252: {
                len = 2;
                break;
            }
            case 253: {
                len = 4;
                break;
            }
            case 254: {
                len = 8;
                break;
            }
            case 255: {
                return null;
            }
            default: {
                return lower;
            }
        }
        long value = 0L;
        int shift = 0;
        for (int i = 0; i < len; ++i) {
            value |= (long)this.in.read() << shift;
            shift += 8;
        }
        return value;
    }

    private String readString() {
        byte[] bytes = this.readBytes();
        return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
    }

    private byte[] readBytes() {
        Long len = this.readNumber();
        if (len == null) {
            return null;
        }
        if (len > (long)this.in.available()) {
            throw new FingerprintException("incorrect length");
        }
        byte[] bytes = new byte[len.intValue()];
        this.in.read(bytes, 0, bytes.length);
        return bytes;
    }

    private Object read(Object schema) {
        String type;
        if (schema.equals("boolean")) {
            return this.readBoolean();
        }
        if (schema.equals("byte")) {
            Long l = this.readNumber();
            return l != null ? Byte.valueOf(l.byteValue()) : null;
        }
        if (schema.equals("short")) {
            Long l = this.readNumber();
            return l != null ? Short.valueOf(l.shortValue()) : null;
        }
        if (schema.equals("int")) {
            Long l = this.readNumber();
            return l != null ? Integer.valueOf(l.intValue()) : null;
        }
        if (schema.equals("long")) {
            return this.readNumber();
        }
        if (schema.equals("Timestamp")) {
            return Util.toTimestamp(this.readNumber());
        }
        if (schema.equals("String")) {
            return this.readString();
        }
        if (schema.equals("byte[]")) {
            return this.readBytes();
        }
        if (schema.equals("InetAddress")) {
            try {
                byte[] bytes = this.readBytes();
                return bytes != null ? InetAddress.getByAddress(bytes) : null;
            }
            catch (UnknownHostException e) {
                throw new FingerprintException("incorrect inet address", e);
            }
        }
        if (schema instanceof String && (type = (String)schema).endsWith("[]")) {
            Long size = this.readNumber();
            if (size == null) {
                return null;
            }
            long edge = this.in.available() - size.intValue();
            if (edge < 0L) {
                throw new FingerprintException("incorrect size");
            }
            ArrayList<Object> list = new ArrayList<Object>();
            String elementType = type.substring(0, type.length() - 2);
            while ((long)this.in.available() > edge) {
                list.add(this.read(elementType));
            }
            return list;
        }
        if (schema.getClass().isArray()) {
            if (!FieldWithSchema.class.isAssignableFrom((Class<?>)schema.getClass().componentType())) {
                throw new FingerprintException("fingerprint schema should be a String or a FieldWithSchema[], but got %s".formatted(schema.getClass()));
            }
            assert (schema instanceof FieldWithSchema[]);
            return this.read(schema);
        }
        throw new FingerprintException("unknown field type in the schema: %s".formatted(schema));
    }

    public Fingerprint read(Function<Integer, FieldWithSchema[]> schemaProvider) {
        Long version = this.readNumber();
        if (version == null) {
            return null;
        }
        FieldWithSchema[] schema = schemaProvider.apply(version.intValue());
        if (schema == null) {
            throw new FingerprintException("no schema for version %d".formatted(version));
        }
        Fingerprint fingerprint = new Fingerprint(version.intValue());
        for (FieldWithSchema field : schema) {
            fingerprint.put(field.name(), this.read(field.schema()));
        }
        return fingerprint;
    }

    public int available() {
        return this.in.available();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }
}

