/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.Pbkdf2WithHmacSha512;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public enum JavaxPbkdf2WithHmacSha512 implements Pbkdf2WithHmacSha512
{
    INSTANCE;

    private SecretKeyFactory skf = JavaxPbkdf2WithHmacSha512.getPbkdf2WithHmacSha512();

    @Override
    public byte[] hash(char[] chars, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(chars, salt, 2048, 512);
        byte[] encoded = this.generateSecretKey(spec).getEncoded();
        spec.clearPassword();
        return encoded;
    }

    private SecretKey generateSecretKey(final PBEKeySpec spec) {
        return CheckedExceptionToRuntime.toRuntime(new CheckedExceptionToRuntime.Func<SecretKey>(){

            @Override
            public SecretKey run() throws Exception {
                return JavaxPbkdf2WithHmacSha512.this.skf.generateSecret(spec);
            }
        });
    }

    private static SecretKeyFactory getPbkdf2WithHmacSha512() {
        return CheckedExceptionToRuntime.toRuntime(new CheckedExceptionToRuntime.Func<SecretKeyFactory>(){

            @Override
            public SecretKeyFactory run() throws Exception {
                return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
        });
    }
}

