/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

public class Util {
    public static Timestamp now() {
        return Timestamp.from(Instant.now());
    }

    public static Long toEpochSecond(Timestamp timestamp) {
        return timestamp != null ? Long.valueOf(timestamp.getTime() / 1000L) : null;
    }

    public static Timestamp toTimestamp(Long epochSecond) {
        return epochSecond != null ? Timestamp.from(Instant.ofEpochSecond(epochSecond)) : null;
    }

    public static String formatTimestamp(long timestamp) {
        return DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneOffset.UTC));
    }

    public static String base64encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64decode(String s) {
        return Base64.getDecoder().decode(s);
    }

    public static String base64urlencode(byte[] bytes) {
        return bytes != null ? Base64.getUrlEncoder().withoutPadding().encodeToString(bytes) : null;
    }

    public static String dump(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            buf.append(Util.hexByte(b));
        }
        return buf.toString();
    }

    public static String dumpShort(byte[] bytes) {
        int i;
        if (bytes.length <= 16) {
            return Util.dump(bytes);
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < 8; ++i) {
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            buf.append(Util.hexByte(bytes[i]));
        }
        buf.append(" ...");
        for (i = bytes.length - 8; i < bytes.length; ++i) {
            buf.append(' ');
            buf.append(Util.hexByte(bytes[i]));
        }
        return buf.toString();
    }

    public static String hexByte(byte b) {
        return "%02X".formatted(b >= 0 ? b : 256 + b);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

