/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.body;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.moera.lib.node.types.body.BodyDecoded;
import org.moera.lib.node.types.body.BodyMappingException;
import org.moera.lib.node.types.body.LinkPreview;
import org.moera.lib.util.Util;

@JsonSerialize(converter=ToStringConverter.class)
@JsonDeserialize(converter=FromStringConverter.class)
public class Body
implements Cloneable {
    public static final String EMPTY = "{}";
    private String encoded;
    private BodyDecoded decoded = new BodyDecoded();

    public Body() {
    }

    public Body(String encoded) {
        this.setEncoded(encoded);
    }

    private void decode() {
        if (this.encoded == null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.decoded = (BodyDecoded)mapper.readValue(this.encoded, BodyDecoded.class);
        }
        catch (IOException e) {
            throw new BodyMappingException(e);
        }
        this.getLinkPreviews().forEach(lp -> lp.setParent(this));
    }

    private void encode() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.encoded = mapper.writeValueAsString((Object)this.decoded);
        }
        catch (JsonProcessingException e) {
            throw new BodyMappingException(e);
        }
    }

    public String getEncoded() {
        if (this.encoded == null) {
            this.encode();
        }
        return this.encoded;
    }

    public void setEncoded(String encoded) {
        this.encoded = encoded;
        this.decode();
    }

    public String getSubject() {
        return this.decoded.getSubject();
    }

    public void setSubject(String subject) {
        this.decoded.setSubject(subject);
        this.modified();
    }

    public String getText() {
        return this.decoded.getText();
    }

    public void setText(String text) {
        this.decoded.setText(text);
        this.modified();
    }

    public List<LinkPreview> getLinkPreviews() {
        return this.decoded.getLinkPreviews() != null ? Collections.unmodifiableList(this.decoded.getLinkPreviews()) : Collections.emptyList();
    }

    public void setLinkPreviews(List<LinkPreview> linkPreviews) {
        linkPreviews.forEach(lp -> lp.setParent(this));
        this.decoded.setLinkPreviews(linkPreviews);
        this.modified();
    }

    void modified() {
        this.encoded = null;
    }

    public String getAllText() {
        StringBuilder buf = new StringBuilder();
        if (!Util.isEmpty(this.getText())) {
            buf.append(this.getText());
        }
        for (LinkPreview linkPreview : this.getLinkPreviews()) {
            if (!Util.isEmpty(linkPreview.getTitle())) {
                if (!buf.isEmpty()) {
                    buf.append(' ');
                }
                buf.append(linkPreview.getTitle());
            }
            if (Util.isEmpty(linkPreview.getDescription())) continue;
            if (!buf.isEmpty()) {
                buf.append(' ');
            }
            buf.append(linkPreview.getDescription());
        }
        return buf.toString();
    }

    public Body clone() {
        return new Body(this.getEncoded());
    }

    public static class FromStringConverter
    extends StdConverter<String, Body> {
        public Body convert(String s) {
            return new Body(s);
        }
    }

    public static class ToStringConverter
    extends StdConverter<Body, String> {
        public String convert(Body body) {
            return body.getEncoded();
        }
    }
}

