/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.SubscriptionOperations;
import org.moera.lib.node.types.SubscriptionReason;
import org.moera.lib.node.types.SubscriptionType;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SubscriptionDescription
extends Structure
implements Cloneable {
    private SubscriptionType type;
    private String feedName;
    private String remoteNodeName;
    private String remoteFeedName;
    private String remotePostingId;
    private SubscriptionReason reason;
    private SubscriptionOperations operations;

    public SubscriptionType getType() {
        return this.type;
    }

    public void setType(SubscriptionType type) {
        this.type = type;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public String getRemoteNodeName() {
        return this.remoteNodeName;
    }

    public void setRemoteNodeName(String remoteNodeName) {
        this.remoteNodeName = remoteNodeName;
    }

    public String getRemoteFeedName() {
        return this.remoteFeedName;
    }

    public void setRemoteFeedName(String remoteFeedName) {
        this.remoteFeedName = remoteFeedName;
    }

    public String getRemotePostingId() {
        return this.remotePostingId;
    }

    public void setRemotePostingId(String remotePostingId) {
        this.remotePostingId = remotePostingId;
    }

    public SubscriptionReason getReason() {
        return this.reason;
    }

    public void setReason(SubscriptionReason reason) {
        this.reason = reason;
    }

    public SubscriptionOperations getOperations() {
        return this.operations;
    }

    public void setOperations(SubscriptionOperations operations) {
        this.operations = operations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.type, "subscription.type.missing");
        ValidationUtil.maxSize(this.feedName, 63, "subscription.feed-name.wrong-size");
        ValidationUtil.notBlank(this.remoteNodeName, "subscription.remote-node-name.blank");
        ValidationUtil.maxSize(this.remoteNodeName, 63, "subscription.remote-node-name.wrong-size");
        ValidationUtil.maxSize(this.remoteFeedName, 63, "subscription.remote-feed-name.wrong-size");
        ValidationUtil.maxSize(this.remotePostingId, 40, "subscription.remote-posting-id.wrong-size");
    }

    public SubscriptionDescription clone() {
        try {
            return (SubscriptionDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

