/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SheriffOrderReason {
    OTHER,
    UNLAWFUL,
    DEFAMATORY,
    THREAT,
    SPAM,
    SCAM,
    MALWARE,
    COPYRIGHT,
    IMPERSONATING,
    PRIVACY;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SheriffOrderReason type) {
        return type != null ? type.getValue() : null;
    }

    public static SheriffOrderReason forValue(String value) {
        try {
            return SheriffOrderReason.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SheriffOrderReason parse(String value) {
        return SheriffOrderReason.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

