/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SearchContentUpdateType {
    BLOCK,
    COMMENT_ADD,
    COMMENT_UPDATE,
    COMMENT_DELETE,
    FRIEND,
    PROFILE,
    POSTING_ADD,
    POSTING_UPDATE,
    POSTING_DELETE,
    REACTION_ADD,
    REACTION_DELETE,
    REACTIONS_DELETE_ALL,
    SUBSCRIBE,
    UNBLOCK,
    UNFRIEND,
    UNSUBSCRIBE;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SearchContentUpdateType type) {
        return type != null ? type.getValue() : null;
    }

    public static SearchContentUpdateType forValue(String value) {
        try {
            return SearchContentUpdateType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SearchContentUpdateType parse(String value) {
        return SearchContentUpdateType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

