/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PushContentType {
    STORY_ADDED,
    STORY_DELETED,
    FEED_UPDATED;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(PushContentType type) {
        return type != null ? type.getValue() : null;
    }

    public static PushContentType forValue(String value) {
        try {
            return PushContentType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static PushContentType parse(String value) {
        return PushContentType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

