/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.FundraiserInfo;
import org.moera.lib.node.types.ProfileOperations;
import org.moera.lib.node.types.SourceFormat;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProfileAttributes
extends Structure
implements Cloneable {
    private String fullName;
    private String gender;
    private String email;
    private String title;
    private String bioSrc;
    private SourceFormat bioSrcFormat;
    private String avatarId;
    private List<FundraiserInfo> fundraisers;
    private ProfileOperations operations;

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBioSrc() {
        return this.bioSrc;
    }

    public void setBioSrc(String bioSrc) {
        this.bioSrc = bioSrc;
    }

    public SourceFormat getBioSrcFormat() {
        return this.bioSrcFormat;
    }

    public void setBioSrcFormat(SourceFormat bioSrcFormat) {
        this.bioSrcFormat = bioSrcFormat;
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    public List<FundraiserInfo> getFundraisers() {
        return this.fundraisers;
    }

    public void setFundraisers(List<FundraiserInfo> fundraisers) {
        this.fundraisers = fundraisers;
    }

    public ProfileOperations getOperations() {
        return this.operations;
    }

    public void setOperations(ProfileOperations operations) {
        this.operations = operations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.fullName, 96, "profile.full-name.wrong-size");
        ValidationUtil.maxSize(this.gender, 31, "profile.gender.wrong-size");
        ValidationUtil.maxSize(this.email, 63, "profile.email.wrong-size");
        ValidationUtil.email(this.email, "profile.email.invalid");
        ValidationUtil.maxSize(this.title, 120, "profile.title.wrong-size");
        ValidationUtil.maxSize(this.bioSrc, 4096, "profile.bio-src.wrong-size");
    }

    public ProfileAttributes clone() {
        try {
            return (ProfileAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

