/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.carte;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.moera.lib.node.MoeraNode;
import org.moera.lib.node.carte.CarteSource;
import org.moera.lib.node.carte.MoeraCartesException;
import org.moera.lib.node.exception.MoeraNodeException;
import org.moera.lib.node.types.CarteAttributes;
import org.moera.lib.node.types.CarteInfo;
import org.moera.lib.node.types.Scope;

public class MoeraCarteSource
implements CarteSource {
    private final MoeraNode node;
    private final long clientScope;
    private final long adminScope;
    private final String targetNodeName;
    private List<CarteInfo> cartes = Collections.emptyList();

    public MoeraCarteSource(MoeraNode node, Long clientScope, Long adminScope, String targetNodeName) {
        this.node = node;
        this.clientScope = clientScope != null ? clientScope.longValue() : Scope.ALL.getMask();
        this.adminScope = adminScope != null ? adminScope.longValue() : Scope.NONE.getMask();
        this.targetNodeName = targetNodeName;
    }

    public void renew() {
        CarteAttributes attributes = new CarteAttributes();
        attributes.setClientScope(Scope.toValues(this.clientScope));
        attributes.setAdminScope(Scope.toValues(this.adminScope));
        attributes.setNodeName(this.targetNodeName);
        try {
            this.cartes = this.node.createCartes(attributes).getCartes();
        }
        catch (MoeraNodeException e) {
            throw new MoeraCartesException("Error obtaining cartes from the node", e);
        }
    }

    @Override
    public String getCarte() {
        long now;
        boolean renewed = false;
        while (true) {
            now = Instant.now().toEpochMilli();
            this.cartes = this.cartes.stream().filter(c -> c.getDeadline() > now).toList();
            if (!this.cartes.isEmpty()) break;
            if (renewed) {
                throw new MoeraCartesException("Could not obtain a valid carte from the node");
            }
            this.renew();
            renewed = true;
        }
        for (CarteInfo carte : this.cartes) {
            if (carte.getBeginning() > now) continue;
            return carte.getCarte();
        }
        throw new MoeraCartesException("Could not obtain a carte valid for now");
    }
}

