/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.moera.lib.node.NodeAuth;
import org.moera.lib.node.QueryParam;
import org.moera.lib.node.carte.CarteSource;
import org.moera.lib.node.exception.MoeraNodeApiAuthenticationException;
import org.moera.lib.node.exception.MoeraNodeApiException;
import org.moera.lib.node.exception.MoeraNodeApiNotFoundException;
import org.moera.lib.node.exception.MoeraNodeApiOperationException;
import org.moera.lib.node.exception.MoeraNodeApiValidationException;
import org.moera.lib.node.exception.MoeraNodeCallException;
import org.moera.lib.node.exception.MoeraNodeConnectionException;
import org.moera.lib.node.exception.MoeraNodeException;

public class NodeApiClient {
    private String root;
    private String rootSecret;
    private String token;
    private String carte;
    private CarteSource carteSource;
    private NodeAuth authMethod = NodeAuth.NONE;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final OkHttpClient client = new OkHttpClient();

    public NodeApiClient() {
    }

    public NodeApiClient(String nodeUrl) {
        this.nodeUrl(nodeUrl);
    }

    public String getRoot() {
        return this.root;
    }

    public static String moeraRoot(String url) {
        if (!((String)url).startsWith("http:") && !((String)url).startsWith("https:")) {
            url = "https://" + (String)url;
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        if (((String)url).endsWith("/api")) {
            url = ((String)url).substring(0, ((String)url).length() - 4);
        }
        if (!((String)url).endsWith("/moera")) {
            url = (String)url + "/moera";
        }
        return url;
    }

    public void nodeUrl(String url) {
        this.root = NodeApiClient.moeraRoot(url);
    }

    public void rootSecret(String secret) {
        this.rootSecret = secret;
    }

    public void token(String token) {
        this.token = token;
    }

    public void carte(String carte) {
        this.carte = carte;
    }

    public void carteSource(CarteSource carteSource) {
        this.carteSource = carteSource;
    }

    public void authMethod(NodeAuth authMethod) {
        this.authMethod = authMethod;
    }

    public void noAuth() {
        this.authMethod(NodeAuth.NONE);
    }

    public void auth() {
        this.authMethod(NodeAuth.PEER);
    }

    public void authAdmin() {
        this.authMethod(NodeAuth.ADMIN);
    }

    public void authRootAdmin() {
        this.authMethod(NodeAuth.ROOT_ADMIN);
    }

    public <T> T call(String location, QueryParam[] params, String method, Object body, TypeReference<T> resultClass) throws MoeraNodeException {
        AtomicReference result = new AtomicReference();
        this.call(location, params, method, body, (ResponseBody responseBody) -> {
            try {
                result.set(this.objectMapper.readValue(responseBody.string(), resultClass));
            }
            catch (IOException e) {
                throw new MoeraNodeException("Server returned incorrect response", e);
            }
        });
        return (T)result.get();
    }

    public void call(String location, QueryParam[] params, String method, Object body, ResponseConsumer responseConsumer) throws MoeraNodeException {
        RequestBody requestBody;
        try {
            requestBody = body != null ? RequestBody.create((String)this.objectMapper.writeValueAsString(body), (MediaType)MediaType.parse((String)"application/json")) : null;
        }
        catch (JsonProcessingException e) {
            throw new MoeraNodeCallException("Cannot encode the request body", e);
        }
        this.call(location, params, method, requestBody, responseConsumer);
    }

    public <T> T call(String location, QueryParam[] params, String method, Path body, String contentType, TypeReference<T> resultClass) throws MoeraNodeException {
        RequestBody requestBody = body != null ? RequestBody.create((File)body.toFile(), (MediaType)MediaType.parse((String)contentType)) : null;
        AtomicReference result = new AtomicReference();
        this.call(location, params, method, requestBody, (ResponseBody responseBody) -> {
            try {
                result.set(this.objectMapper.readValue(responseBody.string(), resultClass));
            }
            catch (IOException e) {
                throw new MoeraNodeException("Server returned incorrect response", e);
            }
        });
        return (T)result.get();
    }

    public void call(String location, QueryParam[] params, String method, RequestBody requestBody, ResponseConsumer responseConsumer) throws MoeraNodeException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.method(method, requestBody);
        requestBuilder.addHeader("Accept", "application/json");
        String bearer = null;
        switch (this.authMethod) {
            case PEER: {
                if (this.carteSource != null) {
                    bearer = "carte:" + this.carteSource.getCarte();
                    break;
                }
                if (this.carte != null) {
                    bearer = "carte:" + this.carte;
                    break;
                }
                throw new MoeraNodeCallException("Carte is not set");
            }
            case ADMIN: {
                if (this.token == null) {
                    throw new MoeraNodeCallException("Token is not set");
                }
                bearer = "token:" + this.token;
                break;
            }
            case ROOT_ADMIN: {
                if (this.rootSecret == null) {
                    throw new MoeraNodeCallException("Root secret is not set");
                }
                bearer = "secret:" + this.rootSecret;
            }
        }
        if (bearer != null) {
            requestBuilder.addHeader("Authorization", "Bearer " + bearer);
        }
        if (this.root == null) {
            throw new MoeraNodeCallException("Node URL is not set");
        }
        HttpUrl url = HttpUrl.parse((String)(this.root + "/api" + location));
        if (url == null) {
            throw new MoeraNodeCallException("Node URL is not set");
        }
        if (params != null && params.length > 0) {
            HttpUrl.Builder builder = url.newBuilder();
            for (QueryParam param : params) {
                if (param.value() == null) continue;
                builder.addQueryParameter(param.name(), param.value().toString());
            }
            url = builder.build();
        }
        Request request = requestBuilder.url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (response.body() == null) {
                throw new MoeraNodeException("Server returned empty result");
            }
            this.validateResponseStatus(response.code(), response.body());
            responseConsumer.accept(response.body());
        }
        catch (IOException e) {
            throw new MoeraNodeConnectionException(e);
        }
    }

    private void validateResponseStatus(int status, ResponseBody body) throws MoeraNodeApiException {
        switch (status) {
            case 403: {
                throw new MoeraNodeApiAuthenticationException();
            }
            case 200: 
            case 201: {
                break;
            }
            case 400: {
                throw new MoeraNodeApiValidationException(NodeApiClient.toString(body));
            }
            case 404: {
                throw new MoeraNodeApiNotFoundException(NodeApiClient.toString(body));
            }
            case 409: {
                throw new MoeraNodeApiOperationException(NodeApiClient.toString(body));
            }
            default: {
                throw new MoeraNodeApiException(status, NodeApiClient.toString(body));
            }
        }
    }

    private static String toString(ResponseBody body) {
        try {
            return body != null ? body.string() : "";
        }
        catch (IOException e) {
            return "";
        }
    }

    protected String ue(Object value) throws MoeraNodeException {
        if (value == null) {
            throw new MoeraNodeException("null value is not allowed for path substitution");
        }
        return URLEncoder.encode(value.toString(), StandardCharsets.UTF_8);
    }

    protected String commaSeparatedFlags(QueryParam ... flags) {
        if (flags == null || flags.length == 0) {
            return "";
        }
        return Arrays.stream(flags).filter(flag -> Boolean.TRUE.equals(flag.value())).map(QueryParam::name).collect(Collectors.joining(","));
    }

    public static interface ResponseConsumer {
        public void accept(ResponseBody var1) throws MoeraNodeException;
    }
}

