/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.jsonrpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.moera.lib.jsonrpc.JsonRpcApiException;
import org.moera.lib.jsonrpc.JsonRpcRequest;
import org.moera.lib.jsonrpc.JsonRpcResponse;
import org.moera.lib.jsonrpc.OkHttpFetcher;

public class JsonRpcClient {
    private final Function<JsonRpcRequest, JsonRpcResponse> fetcher;
    private final AtomicInteger id = new AtomicInteger(0);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonRpcClient(String url) {
        this(new OkHttpFetcher(url));
    }

    public JsonRpcClient(Function<JsonRpcRequest, JsonRpcResponse> fetcher) {
        this.fetcher = fetcher;
    }

    protected <T> T fetch(TypeReference<T> result, String method, Object ... parameters) {
        JsonRpcRequest request = new JsonRpcRequest();
        request.setId(this.id.incrementAndGet());
        request.setMethod(method);
        request.setParams(this.objectMapper.valueToTree((Object)parameters));
        JsonRpcResponse response = this.fetcher.apply(request);
        if (response.getError() != null) {
            throw new JsonRpcApiException(response.getError());
        }
        if (result != null) {
            return (T)this.objectMapper.convertValue(response.getResult(), result);
        }
        return null;
    }

    protected <T> T fetch(TypeReference<T> result, String method, Map<String, Object> parameters) {
        JsonRpcRequest request = new JsonRpcRequest();
        request.setId(this.id.incrementAndGet());
        request.setMethod(method);
        request.setParams(this.objectMapper.valueToTree(parameters));
        JsonRpcResponse response = this.fetcher.apply(request);
        if (response.getError() != null) {
            throw new JsonRpcApiException(response.getError());
        }
        if (result != null) {
            return (T)this.objectMapper.convertValue(response.getResult(), result);
        }
        return null;
    }
}

