/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SheriffOrderForPostingAddedNotification
extends Notification {
    private String remoteNodeName;
    private String remoteFeedName;
    private String postingHeading;
    private String postingId;
    private String orderId;

    public SheriffOrderForPostingAddedNotification() {
        super(NotificationType.SHERIFF_ORDER_FOR_POSTING_ADDED);
    }

    public String getRemoteNodeName() {
        return this.remoteNodeName;
    }

    public void setRemoteNodeName(String remoteNodeName) {
        this.remoteNodeName = remoteNodeName;
    }

    public String getRemoteFeedName() {
        return this.remoteFeedName;
    }

    public void setRemoteFeedName(String remoteFeedName) {
        this.remoteFeedName = remoteFeedName;
    }

    public String getPostingHeading() {
        return this.postingHeading;
    }

    public void setPostingHeading(String postingHeading) {
        this.postingHeading = postingHeading;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notBlank(this.remoteNodeName, "sheriff-order.remote-node-name.empty");
        ValidationUtil.maxSize(this.remoteNodeName, 63, "sheriff-order.remote-node-name.wrong-size");
        ValidationUtil.notBlank(this.remoteFeedName, "sheriff-order.remote-feed-name.empty");
        ValidationUtil.maxSize(this.remoteFeedName, 63, "sheriff-order.remote-feed-name.wrong-size");
        ValidationUtil.maxSize(this.postingHeading, 255, "sheriff-order.posting-heading.wrong-size");
        ValidationUtil.notBlank(this.postingId, "sheriff-order.posting-id.empty");
        ValidationUtil.maxSize(this.postingId, 40, "sheriff-order.posting-id.wrong-size");
        ValidationUtil.notBlank(this.orderId, "sheriff-order.order-id.empty");
        ValidationUtil.maxSize(this.orderId, 40, "sheriff-order.order-id.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("remoteNodeName", LogUtil.format(this.remoteNodeName)));
        parameters.add(LogPair.of("remoteFeedName", LogUtil.format(this.remoteFeedName)));
        parameters.add(LogPair.of("postingHeading", LogUtil.format(this.postingHeading)));
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("orderId", LogUtil.format(this.orderId)));
    }
}

