/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import org.moera.lib.node.types.notifications.AskedNotification;
import org.moera.lib.node.types.notifications.BlockingAddedNotification;
import org.moera.lib.node.types.notifications.BlockingDeletedNotification;
import org.moera.lib.node.types.notifications.CommentReactionAddedNotification;
import org.moera.lib.node.types.notifications.CommentReactionDeletedAllNotification;
import org.moera.lib.node.types.notifications.CommentReactionDeletedNotification;
import org.moera.lib.node.types.notifications.FriendGroupDeletedNotification;
import org.moera.lib.node.types.notifications.FriendGroupUpdatedNotification;
import org.moera.lib.node.types.notifications.FriendshipUpdatedNotification;
import org.moera.lib.node.types.notifications.GrantUpdatedNotification;
import org.moera.lib.node.types.notifications.MentionCommentAddedNotification;
import org.moera.lib.node.types.notifications.MentionCommentDeletedNotification;
import org.moera.lib.node.types.notifications.MentionPostingAddedNotification;
import org.moera.lib.node.types.notifications.MentionPostingDeletedNotification;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.PostingCommentAddedNotification;
import org.moera.lib.node.types.notifications.PostingCommentDeletedNotification;
import org.moera.lib.node.types.notifications.PostingCommentsUpdatedNotification;
import org.moera.lib.node.types.notifications.PostingDeletedNotification;
import org.moera.lib.node.types.notifications.PostingImportantUpdateNotification;
import org.moera.lib.node.types.notifications.PostingReactionAddedNotification;
import org.moera.lib.node.types.notifications.PostingReactionDeletedAllNotification;
import org.moera.lib.node.types.notifications.PostingReactionDeletedNotification;
import org.moera.lib.node.types.notifications.PostingReactionsUpdatedNotification;
import org.moera.lib.node.types.notifications.PostingUpdatedNotification;
import org.moera.lib.node.types.notifications.ProfileUpdatedNotification;
import org.moera.lib.node.types.notifications.ReplyCommentAddedNotification;
import org.moera.lib.node.types.notifications.ReplyCommentDeletedNotification;
import org.moera.lib.node.types.notifications.SearchEngineClickedNotification;
import org.moera.lib.node.types.notifications.SheriffComplaintDecidedNotification;
import org.moera.lib.node.types.notifications.SheriffOrderForCommentAddedNotification;
import org.moera.lib.node.types.notifications.SheriffOrderForCommentDeletedNotification;
import org.moera.lib.node.types.notifications.SheriffOrderForPostingAddedNotification;
import org.moera.lib.node.types.notifications.SheriffOrderForPostingDeletedNotification;
import org.moera.lib.node.types.notifications.StoryAddedNotification;
import org.moera.lib.node.types.notifications.UserListItemAddedNotification;
import org.moera.lib.node.types.notifications.UserListItemDeletedNotification;

public enum NotificationType {
    MENTION_POSTING_ADDED(MentionPostingAddedNotification.class),
    MENTION_POSTING_DELETED(MentionPostingDeletedNotification.class),
    STORY_ADDED(StoryAddedNotification.class),
    POSTING_UPDATED(PostingUpdatedNotification.class),
    POSTING_DELETED(PostingDeletedNotification.class),
    POSTING_REACTIONS_UPDATED(PostingReactionsUpdatedNotification.class),
    MENTION_COMMENT_ADDED(MentionCommentAddedNotification.class),
    MENTION_COMMENT_DELETED(MentionCommentDeletedNotification.class),
    POSTING_COMMENTS_UPDATED(PostingCommentsUpdatedNotification.class),
    REPLY_COMMENT_ADDED(ReplyCommentAddedNotification.class),
    REPLY_COMMENT_DELETED(ReplyCommentDeletedNotification.class),
    COMMENT_REACTION_ADDED(CommentReactionAddedNotification.class),
    COMMENT_REACTION_DELETED(CommentReactionDeletedNotification.class),
    COMMENT_REACTION_DELETED_ALL(CommentReactionDeletedAllNotification.class),
    POSTING_COMMENT_ADDED(PostingCommentAddedNotification.class),
    POSTING_COMMENT_DELETED(PostingCommentDeletedNotification.class),
    PROFILE_UPDATED(ProfileUpdatedNotification.class),
    POSTING_IMPORTANT_UPDATE(PostingImportantUpdateNotification.class),
    POSTING_REACTION_ADDED(PostingReactionAddedNotification.class),
    POSTING_REACTION_DELETED(PostingReactionDeletedNotification.class),
    POSTING_REACTION_DELETED_ALL(PostingReactionDeletedAllNotification.class),
    FRIENDSHIP_UPDATED(FriendshipUpdatedNotification.class),
    FRIEND_GROUP_UPDATED(FriendGroupUpdatedNotification.class),
    FRIEND_GROUP_DELETED(FriendGroupDeletedNotification.class),
    ASKED(AskedNotification.class),
    BLOCKING_ADDED(BlockingAddedNotification.class),
    BLOCKING_DELETED(BlockingDeletedNotification.class),
    SHERIFF_ORDER_FOR_POSTING_ADDED(SheriffOrderForPostingAddedNotification.class),
    SHERIFF_ORDER_FOR_POSTING_DELETED(SheriffOrderForPostingDeletedNotification.class),
    SHERIFF_ORDER_FOR_COMMENT_ADDED(SheriffOrderForCommentAddedNotification.class),
    SHERIFF_ORDER_FOR_COMMENT_DELETED(SheriffOrderForCommentDeletedNotification.class),
    SHERIFF_COMPLAINT_DECIDED(SheriffComplaintDecidedNotification.class),
    USER_LIST_ITEM_ADDED(UserListItemAddedNotification.class),
    USER_LIST_ITEM_DELETED(UserListItemDeletedNotification.class),
    GRANT_UPDATED(GrantUpdatedNotification.class),
    SEARCH_ENGINE_CLICKED(SearchEngineClickedNotification.class);

    private final Class<? extends Notification> structure;

    private NotificationType(Class<? extends Notification> structure) {
        this.structure = structure;
    }

    public Class<? extends Notification> getStructure() {
        return this.structure;
    }

    public String getValue() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public static NotificationType forValue(String value) {
        String name = value.toUpperCase().replace('-', '_');
        try {
            return NotificationType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

